/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.contrib.ChopPolygonConnector;
import CH.ifa.draw.contrib.OutlineFigure;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.standard.RelativeLocator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.Vector;

public class UMLNoteFigure
extends TextFigure
implements OutlineFigure {
    private static final LineConnection ANCHOR = new LineConnection(null, null, "1 2");

    public UMLNoteFigure() {
        this.setFrameColor(Color.black);
        this.setFillColor(Color.white);
    }

    public UMLNoteFigure(Color frameColor) {
        this.setFrameColor(frameColor);
        this.setFillColor(Color.white);
        this.setAttribute("TextColor", frameColor);
        ANCHOR.setFrameColor(frameColor);
        ANCHOR.setAttribute("LineShape", (Object)1);
        ANCHOR.setAttribute("BSplineSegments", (Object)15);
        ANCHOR.setAttribute("BSplineDegree", (Object)2);
    }

    public Vector<Handle> handles() {
        Vector handles = super.handles();
        handles.addElement(new ConnectionHandle((Figure)this, RelativeLocator.center(), (ConnectionFigure)ANCHOR));
        return handles;
    }

    public void drawBackground(Graphics g) {
        int i;
        Polygon fPoly = this.outline(false, g);
        GeneralPath shape = new GeneralPath();
        int[] x = fPoly.xpoints;
        int[] y = fPoly.ypoints;
        int max = fPoly.npoints;
        shape.moveTo(x[i], y[i]);
        for (i = 0; i < max; ++i) {
            shape.lineTo(x[i], y[i]);
        }
        shape.closePath();
        ((Graphics2D)g).fill(shape);
    }

    public void drawFrame(Graphics g) {
        int i;
        Polygon fPoly = this.outline(true, g);
        GeneralPath shape = new GeneralPath();
        int[] x = fPoly.xpoints;
        int[] y = fPoly.ypoints;
        int max = fPoly.npoints;
        shape.moveTo(x[i], y[i]);
        for (i = 0; i < max; ++i) {
            shape.lineTo(x[i], y[i]);
        }
        shape.closePath();
        ((Graphics2D)g).draw(shape);
    }

    public Rectangle displayBox() {
        Rectangle box = super.displayBox();
        return new Rectangle(box.x - 5, box.y - 5, box.width + 10, box.height + 10);
    }

    protected Dimension getLineDimension(int i, Graphics g) {
        Dimension dim = super.getLineDimension(i, g);
        if (i == 0) {
            dim.width += this.dogsEarSize(g);
        }
        return dim;
    }

    private int dogsEarSize(Graphics g) {
        return UMLNoteFigure.getMetrics((Font)this.getLineFont(0), (Graphics)g).getHeight() + 5;
    }

    public Polygon outline() {
        return this.outline(false, null);
    }

    public Polygon outline(boolean line, Graphics g) {
        Rectangle box = this.displayBox();
        Polygon outline = new Polygon();
        int dogsEarSize = this.dogsEarSize(g);
        outline.addPoint(box.x, box.y);
        outline.addPoint(box.x + box.width - dogsEarSize, box.y);
        if (line) {
            outline.addPoint(box.x + box.width - dogsEarSize, box.y + dogsEarSize);
            outline.addPoint(box.x + box.width - dogsEarSize, box.y);
        }
        outline.addPoint(box.x + box.width, box.y + dogsEarSize);
        if (line) {
            outline.addPoint(box.x + box.width - dogsEarSize, box.y + dogsEarSize);
            outline.addPoint(box.x + box.width, box.y + dogsEarSize);
        }
        outline.addPoint(box.x + box.width, box.y + box.height);
        outline.addPoint(box.x, box.y + box.height);
        return outline;
    }

    public boolean containsPoint(int x, int y) {
        if (this.isVisible()) {
            return this.outline().contains(x, y);
        }
        return false;
    }

    public Connector connectorAt(int x, int y) {
        return new ChopPolygonConnector((Figure)this);
    }
}

