/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.ElbowTextLocator;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.formalism.fs.ShadowConcept;
import de.renew.formalism.fs.ShadowIsa;
import de.renew.gui.IsaArrowTip;
import de.renew.gui.fs.ConceptConnection;
import de.renew.gui.fs.ConceptFigure;
import de.renew.shadow.ShadowNetElement;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.Vector;

public class IsaConnection
extends ConceptConnection {
    private boolean _isDisjunctive;

    public IsaConnection() {
        this(true);
    }

    public IsaConnection(boolean isDisjunctive) {
        super((ArrowTip)new IsaArrowTip());
        this._isDisjunctive = isDisjunctive;
        this.setFillColor(Color.white);
    }

    @Override
    protected ShadowNetElement createShadow(ShadowConcept from, ShadowConcept to) {
        return new ShadowIsa(from, to, this._isDisjunctive);
    }

    public boolean isDisjunctive() {
        return this._isDisjunctive;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("IsaType")) {
            this._isDisjunctive = (Boolean)value;
            this.willChange();
            if (!this._isDisjunctive && this.fPoints.size() > 2) {
                Point start = this.startPoint();
                Point end = this.endPoint();
                this.fPoints.removeAllElements();
                this.fPoints.addElement(start);
                this.fPoints.addElement(end);
            }
            this.updateConnection();
            this.changed();
        } else {
            super.setAttribute(name, value);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeBoolean(this._isDisjunctive);
    }

    public void read(StorableInput dr) throws IOException {
        this._isDisjunctive = false;
        this.setFillColor(Color.white);
        super.read(dr);
        this._isDisjunctive = dr.readBoolean();
    }

    public void updateConnection() {
        super.updateConnection();
        if (this._isDisjunctive) {
            this.updatePoints();
        }
    }

    public void layoutConnection() {
        if (!this._isDisjunctive) {
            super.layoutConnection();
        }
    }

    public Vector<Handle> handles() {
        if (this._isDisjunctive) {
            int i;
            Vector<Handle> handles = new Vector<Handle>(this.fPoints.size() * 2);
            handles.addElement((Handle)new ChangeConnectionStartHandle((Figure)this));
            for (i = 1; i < this.fPoints.size() - 1; ++i) {
                handles.addElement((Handle)new NullHandle((Figure)this, IsaConnection.locator((int)i)));
            }
            handles.addElement((Handle)new ChangeConnectionEndHandle((Figure)this));
            for (i = 0; i < this.fPoints.size() - 1; ++i) {
                handles.addElement((Handle)new ElbowHandle((LineConnection)this, i));
            }
            return handles;
        }
        return super.handles();
    }

    public Locator connectedTextLocator(Figure f) {
        if (this._isDisjunctive) {
            return new ElbowTextLocator();
        }
        return super.connectedTextLocator(f);
    }

    protected void updatePoints() {
        this.willChange();
        Point start = this.startPoint();
        Point end = this.endPoint();
        this.fPoints.removeAllElements();
        this.fPoints.addElement(start);
        if (start.x != end.x && start.y != end.y) {
            this.fPoints.addElement(new Point(start.x, (start.y + end.y) / 2));
            this.fPoints.addElement(new Point(end.x, (start.y + end.y) / 2));
        }
        this.fPoints.addElement(end);
        this.changed();
    }

    protected void handleConnect(Figure start, Figure end) {
        if (end instanceof ConceptFigure && "interface".equals(((ConceptFigure)end).getStereotype())) {
            this.setAttribute("LineStyle", "10");
        }
    }
}

