/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Palette;
import de.renew.formalism.gui.JavaGuiCreator;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;
import de.renew.gui.fs.AssocConnection;
import de.renew.gui.fs.ConceptFigure;
import de.renew.gui.fs.FSFigure;
import de.renew.gui.fs.FSNodeFigure;
import de.renew.gui.fs.FeatureConnection;
import de.renew.gui.fs.IsaConnection;
import de.renew.gui.fs.SetFSRenderModeCommand;
import de.renew.gui.fs.UMLNoteFigure;
import de.renew.gui.tool.CPNTextTool;
import javax.swing.JMenuItem;

public class FSGuiConfigurator
extends JavaGuiCreator {
    protected static final String IMAGES = "FS/src/main/resources/de/renew/fs/images/";
    protected static final String MENU_ID_ISATYPE = "de.renew.gui.fs.isatype";

    public Palette createPalette() {
        Palette palette = super.createPalette();
        GuiPlugin starter = GuiPlugin.getCurrent();
        DrawingEditor editor = starter.getDrawingEditor();
        PaletteHolder paletteHolder = starter.getPaletteHolder();
        if (palette == null) {
            palette = new Palette("Information Modeling Tools");
        }
        CPNTextTool tool = new CPNTextTool(editor, (CPNTextFigure)new FSFigure(), false);
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/FS", "Feature Structure Tool", (Tool)tool));
        tool = new TextTool(editor, (TextFigure)new FSNodeFigure());
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/FSNODE", "Feature Structure Node Tool", (Tool)tool));
        tool = new ConnectionTool(editor, (ConnectionFigure)new FeatureConnection());
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/FEATURE", "Feature Tool", (Tool)tool));
        tool = new TextTool(editor, (TextFigure)new ConceptFigure());
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/CONCEPT", "Concept Tool", (Tool)tool));
        tool = new ConnectionTool(editor, (ConnectionFigure)new IsaConnection());
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/DISISA", "Disjunctive Is-A Tool", (Tool)tool));
        tool = new ConnectionTool(editor, (ConnectionFigure)new IsaConnection(false));
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/ISA", "Is-A Tool", (Tool)tool));
        tool = new ConnectionTool(editor, (ConnectionFigure)new AssocConnection());
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/ASSOC", "Association Tool", (Tool)tool));
        tool = new TextTool(editor, (TextFigure)new UMLNoteFigure());
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/UMLNOTE", "UML Note Tool", (Tool)tool));
        tool = new ConnectionTool(editor, (ConnectionFigure)new LineConnection(null, null, "10"));
        palette.add(paletteHolder.createToolButton("FS/src/main/resources/de/renew/fs/images/ANCHOR", "UML Note Anchor Tool", (Tool)tool));
        return palette;
    }

    public JMenuItem createMenu() {
        CommandMenu menu = new CommandMenu("FS options");
        JMenuItem javaMenu = super.createMenu();
        menu.add(javaMenu);
        this.addFSOptions(menu);
        return menu;
    }

    protected void addFSOptions(CommandMenu optionsMenu) {
        CommandMenu renderModeMenu = new CommandMenu("Object Rendering");
        renderModeMenu.add((Command)new SetFSRenderModeCommand("Feature Structures", false));
        renderModeMenu.add((Command)new SetFSRenderModeCommand("UML Notation", true));
        optionsMenu.add((JMenuItem)renderModeMenu);
    }

    public void formalismActivated() {
        super.formalismActivated();
        MenuManager mgr = DrawPlugin.getCurrent().getMenuManager();
        CommandMenu isaTypeMenu = new CommandMenu("Is-A Type");
        isaTypeMenu.add((Command)new ChangeAttributeCommand("disjunctive", "IsaType", (Object)Boolean.TRUE));
        isaTypeMenu.add((Command)new ChangeAttributeCommand("multiple", "IsaType", (Object)Boolean.FALSE));
        mgr.registerMenu("Attributes", (JMenuItem)isaTypeMenu, MENU_ID_ISATYPE);
    }

    public void formalismDeactivated() {
        MenuManager mgr = DrawPlugin.getCurrent().getMenuManager();
        mgr.unregisterMenu(MENU_ID_ISATYPE);
        super.formalismDeactivated();
    }
}

