/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.util.ColorMap;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.fs.AssocConnection;
import de.renew.gui.fs.ConceptFigure;
import java.awt.Point;

public class AssociationHandle
extends ConnectionHandle {
    private int _line;
    private String _name;
    private String _type;
    private ConceptFigure _owner;
    private boolean _isCollection;

    public AssociationHandle(ConceptFigure owner, int line, String name, String type, boolean isCollection, Locator locator, ConnectionFigure prototype) {
        super((Figure)owner, locator, prototype);
        this._owner = owner;
        this._line = line;
        this._name = name;
        this._type = type;
        this._isCollection = isCollection;
    }

    protected ConnectionFigure createConnection() {
        return new AssocConnection();
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        if (this.findConnectableFigure(x, y, view.drawing()) != this._owner) {
            Connector target = this.findConnectionTarget(x, y, view.drawing());
            if (target == null && this._owner.findFigureInside(x, y) == null) {
                ConceptFigure endFigure = new ConceptFigure();
                endFigure.moveBy(x, y);
                endFigure.setText(this._type);
                view.add((Figure)endFigure);
            }
            String[] lines = this._owner.getLines();
            StringBuffer newText = new StringBuffer();
            for (int i = 0; i < lines.length; ++i) {
                if (i == this._line) continue;
                if (i > 0) {
                    newText.append('\n');
                }
                newText.append(lines[i]);
            }
            this._owner.setText(newText.toString());
            CPNTextFigure nameFigure = new CPNTextFigure(1);
            nameFigure.setAttribute("FillColor", (Object)ColorMap.BACKGROUND);
            nameFigure.setText(this._name);
            nameFigure.setParent((ParentFigure)((AssocConnection)this.getConnection()));
            view.drawing().add((Figure)nameFigure);
            CPNTextFigure starFigure = null;
            if (this._isCollection) {
                starFigure = new CPNTextFigure(1);
                starFigure.setAttribute("FillColor", (Object)ColorMap.NONE);
                starFigure.setText("*");
                starFigure.setParent((ParentFigure)((AssocConnection)this.getConnection()));
                view.drawing().add((Figure)starFigure);
                Point p1 = starFigure.center();
                starFigure.moveBy((x - p1.x) / 2, (y - p1.y) / 2);
            }
        }
        super.invokeEnd(x, y, anchorX, anchorY, view);
        view.selectionInvalidateHandles();
    }
}

