/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fs;

import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.formalism.fs.FSUnifier;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Tuple;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.Path;
import java.util.Vector;

public class FSUnifyExpression
implements Expression {
    FeatureStructure _template;
    Vector<Path> _paths;
    Vector<Object> _exprs;

    public FSUnifyExpression(FeatureStructure template, Vector<Path> paths, Vector<Object> exprs) {
        this._template = template;
        this._paths = paths;
        this._exprs = exprs;
    }

    public FeatureStructure getTemplate() {
        return this._template;
    }

    public Vector<Path> getPaths() {
        return this._paths;
    }

    public Vector<Object> getExprs() {
        return this._exprs;
    }

    public boolean isInvertible() {
        return true;
    }

    public Class<?> getType() {
        return FeatureStructure.class;
    }

    public Object startEvaluation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        if (this._exprs.size() > 0) {
            FSUnifier unifier = new FSUnifier(this._template, this._paths, recorder);
            for (int i = 0; i < this._exprs.size(); ++i) {
                Expression expr = (Expression)this._exprs.elementAt(i);
                Unify.unify((Object)unifier.getVariable(i), (Object)expr.startEvaluation(mapper, recorder, checker), (StateRecorder)recorder);
            }
            return unifier._result.getValue();
        }
        return this._template;
    }

    public Object registerCalculation(VariableMapper mapper, StateRecorder recorder, CalculationChecker checker) throws Impossible {
        Tuple tuple = new Tuple(this._exprs.size());
        for (int i = 0; i < this._exprs.size(); ++i) {
            Expression expr = (Expression)this._exprs.elementAt(i);
            Unify.unify((Object)tuple.getComponent(i), (Object)expr.registerCalculation(mapper, recorder, checker), (StateRecorder)recorder);
        }
        Variable source = new Variable((Object)tuple, recorder);
        Variable target = new Variable();
        checker.addLateVariable(source, recorder);
        checker.addCalculated(FeatureStructure.class, (Object)target, source.getValue(), recorder);
        return target.getValue();
    }

    public String toString() {
        int sbSize = 1000;
        String variableSeparator = ", ";
        StringBuffer sb = new StringBuffer(1000);
        sb.append("FSUnifyExpr(");
        sb.append("tmpl: ").append(this._template);
        sb.append(", ");
        sb.append("paths: ").append(this._paths);
        sb.append(", ");
        sb.append("exprs: ").append(this._exprs);
        sb.append(")");
        return sb.toString();
    }
}

