/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.fs;

import collections.CollectionEnumeration;
import de.renew.formalism.fs.FSInscriptionParser;
import de.renew.formalism.fs.FSNetCompiler;
import de.renew.formalism.fs.FSShadowLookupExtension;
import de.renew.formalism.fs.ParsedFSDeclarationNode;
import de.renew.formalism.fs.ShadowAssoc;
import de.renew.formalism.fs.ShadowConcept;
import de.renew.formalism.fs.ShadowIsa;
import de.renew.formalism.fs.SingleFSNetCompiler;
import de.renew.formalism.java.ParseException;
import de.renew.net.NetInstance;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.ShadowPreprocessor;
import de.renew.shadow.SyntaxException;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.CyclicHierarchyException;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.ParsedConjunctiveType;
import de.uni_hamburg.fs.ParsedListType;
import de.uni_hamburg.fs.ParsedType;
import de.uni_hamburg.fs.Partition;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FSNetPreprocessor
implements ShadowPreprocessor {
    public static final Logger LOGGER = Logger.getLogger(FSNetPreprocessor.class);
    public static final String LINK = "Link";
    public static final Name RCV = new Name("rcv");
    public static final Name PARAM = new Name("param");
    private ShadowLookup _shadowLookup;

    public void setShadowLookup(ShadowLookup shadowLookup) {
        this._shadowLookup = shadowLookup;
    }

    protected ShadowLookup getShadowLookup() {
        return this._shadowLookup;
    }

    public void preprocess(ShadowNetSystem netSystem) throws SyntaxException {
        TypeSystem ts = TypeSystem.newInstance();
        Partition topPartition = ts.getTopPartition();
        ConceptImpl linkConcept = new ConceptImpl(LINK);
        linkConcept.addApprop(RCV, (ParsedType)new ParsedConjunctiveType(new ConceptSet(ts.getJavaConcept(NetInstance.class))));
        linkConcept.addApprop(PARAM, ParsedType.PARSED_TOP);
        Iterator iterator = netSystem.elements().iterator();
        while (iterator.hasNext()) {
            this.compileConcepts((ShadowNet)iterator.next(), topPartition);
        }
        iterator = netSystem.elements().iterator();
        while (iterator.hasNext()) {
            this.compileApprops((ShadowNet)iterator.next());
        }
        iterator = netSystem.elements().iterator();
        while (iterator.hasNext()) {
            this.compilePartitions((ShadowNet)iterator.next());
        }
        iterator = netSystem.elements().iterator();
        while (iterator.hasNext()) {
            this.compileIsas((ShadowNet)iterator.next());
        }
        try {
            ts.inheritFeatures();
        }
        catch (UnificationFailure uff) {
            SyntaxException ex;
            if (uff instanceof TypeException) {
                TypeException tex = (TypeException)uff;
                String msg = "Feature \"" + String.valueOf(tex._featureName) + "\" has been redefined illegally in concept \"" + tex._concept.getName() + "\".";
                ex = new SyntaxException(msg, (Throwable)uff);
                ex.addObject((Object)FSShadowLookupExtension.lookup(this._shadowLookup).getApprop(tex._concept, tex._featureName));
            } else {
                ex = new SyntaxException("Unification failure while constructing feature types.", (Throwable)uff);
            }
            throw ex;
        }
    }

    private void compileConcepts(ShadowNet net, Partition topPartition) throws SyntaxException {
        String netName = net.getName();
        for (ShadowNetElement elem : net.elements()) {
            ShadowConcept shadowConcept;
            if (!(elem instanceof ShadowConcept) || !(shadowConcept = (ShadowConcept)elem).getNamespace().equals(netName)) continue;
            String conceptName = shadowConcept.getFullName();
            conceptName = FSNetPreprocessor.withoutStereotype(conceptName);
            LOGGER.debug((Object)("Compiling concept " + conceptName + "..."));
            if (TypeSystem.instance().hasConcept(conceptName)) {
                SyntaxException ex = new SyntaxException("The concept \"" + conceptName + "\" already exists.");
                ex.addObject((Object)shadowConcept);
                throw ex;
            }
            ConceptImpl concept = new ConceptImpl(conceptName);
            FSShadowLookupExtension.lookup(this._shadowLookup).setConcept(shadowConcept, concept);
            if (!shadowConcept.elements().isEmpty()) continue;
            try {
                topPartition.addConcept(concept);
            }
            catch (TypeException tex) {
                throw new RuntimeException(tex.toString());
            }
        }
    }

    private static String withoutStereotype(String str) {
        return str.replaceAll("<<[^>]*>>", "").replaceAll("\n", "");
    }

    private Concept lookup(ShadowConcept shadowConcept) throws SyntaxException {
        String conceptName = FSNetPreprocessor.withoutStereotype(shadowConcept.getFullName());
        if (!TypeSystem.instance().hasConcept(conceptName)) {
            SyntaxException ex = new SyntaxException("Referenced Concept " + conceptName + " does not exist.");
            ex.addObject((Object)shadowConcept);
            throw ex;
        }
        return TypeSystem.instance().conceptForName(conceptName);
    }

    protected SingleFSNetCompiler createSingleFSNetCompiler() {
        return new SingleFSNetCompiler();
    }

    private void compileApprops(ShadowNet net) throws SyntaxException {
        ConceptImpl concept;
        for (ShadowNetElement elem : net.elements()) {
            if (!(elem instanceof ShadowAssoc)) continue;
            ShadowAssoc shadowAssoc = (ShadowAssoc)elem;
            concept = (ConceptImpl)this.lookup(shadowAssoc.getConcept());
            ConceptSet typ = new ConceptSet(this.lookup(shadowAssoc.getType()));
            int mult = shadowAssoc.getMultiplicity();
            Name featureName = shadowAssoc.getFeature();
            ParsedType pt = new ParsedConjunctiveType(typ);
            if (mult != 0) {
                pt = new ParsedListType(mult == 2, pt);
            }
            concept.addApprop(featureName, pt);
            FSShadowLookupExtension.lookup(this._shadowLookup).setApprop(concept, featureName, (ShadowNetElement)shadowAssoc);
        }
        for (ShadowNetElement elem : net.elements()) {
            if (!(elem instanceof ShadowConcept)) continue;
            ShadowConcept shadowConcept = (ShadowConcept)elem;
            concept = (ConceptImpl)this.lookup(shadowConcept);
            SingleFSNetCompiler compiler = this.createSingleFSNetCompiler();
            compiler.setShadowLookup(this._shadowLookup);
            FSInscriptionParser parser = (FSInscriptionParser)compiler.makeParser("\n" + shadowConcept.getApprop());
            parser.setLookup(this._shadowLookup);
            ParsedFSDeclarationNode decl = (ParsedFSDeclarationNode)compiler.makeDeclarationNode(net);
            try {
                decl.addAccess(net.getName(), null);
            }
            catch (ParseException pt) {
                // empty catch block
            }
            parser.setDeclarationNode(decl);
            try {
                OrderedTable approps = parser.parseAppropDef();
                CollectionEnumeration appropenumeration = approps.keys();
                while (appropenumeration.hasMoreElements()) {
                    Name featureName = (Name)appropenumeration.nextElement();
                    concept.addApprop(featureName, (ParsedType)approps.at(featureName));
                    FSShadowLookupExtension.lookup(this._shadowLookup).setApprop(concept, featureName, (ShadowNetElement)shadowConcept);
                }
            }
            catch (ParseException e) {
                SyntaxException ex = FSNetCompiler.makeSyntaxException(e);
                ex.addObject((Object)shadowConcept);
                throw ex;
            }
        }
    }

    private void compilePartitions(ShadowNet net) throws SyntaxException {
        for (ShadowNetElement elem : net.elements()) {
            ShadowIsa shadowIsa;
            if (!(elem instanceof ShadowIsa) || !(shadowIsa = (ShadowIsa)elem).isDisjunctive()) continue;
            ConceptImpl sub = (ConceptImpl)this.lookup(shadowIsa.getSource());
            ConceptImpl supi = (ConceptImpl)this.lookup(shadowIsa.getTarget());
            try {
                FSShadowLookupExtension.lookup(this._shadowLookup).addToSubPartition(supi, sub);
            }
            catch (TypeException tex) {
                SyntaxException ex = new SyntaxException("This disjunction leads to a contradiction.", (Throwable)tex);
                ex.addObject((Object)shadowIsa);
                throw ex;
            }
        }
    }

    private void compileIsas(ShadowNet net) throws SyntaxException {
        for (ShadowNetElement elem : net.elements()) {
            if (!(elem instanceof ShadowIsa)) continue;
            ShadowIsa shadowIsa = (ShadowIsa)elem;
            ConceptImpl sub = (ConceptImpl)this.lookup(shadowIsa.getSource());
            ShadowConcept supi = shadowIsa.getTarget();
            ConceptImpl sup = (ConceptImpl)this.lookup(supi);
            LOGGER.debug((Object)("Compiling is-a from " + sub.getName() + " to " + sup.getName()));
            try {
                sub.addIsa(sup);
            }
            catch (CyclicHierarchyException e) {
                SyntaxException ex = new SyntaxException("This is-a-relation leads to a cyclic type hierarchy.", (Throwable)e);
                ex.addObject((Object)shadowIsa);
                throw ex;
            }
            catch (TypeException te) {
                SyntaxException ex = new SyntaxException("This is-a-relation leads to a contradiction.", (Throwable)te);
                ex.addObject((Object)shadowIsa);
                throw ex;
            }
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object that) {
        return that != null && this.getClass().equals(that.getClass());
    }
}

