/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Calculator;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.HashSet;
import java.util.Set;

public final class CalculationChecker {
    private final Set<Variable> _lateVariables = new HashSet<Variable>();
    private final Set<Variable> _earlyVariables = new HashSet<Variable>();

    public void reset() {
        this._lateVariables.clear();
        this._earlyVariables.clear();
    }

    public void addEarlyVariable(Variable var, StateRecorder recorder) throws Impossible {
        if (!this._earlyVariables.contains(var)) {
            if (recorder != null) {
                recorder.record(() -> this._earlyVariables.remove(var));
            }
            this._earlyVariables.add(var);
        }
    }

    public void addCalculated(Class<?> targetType, Object target, Object source, StateRecorder recorder) throws Impossible {
        Unify.unify(target, new Calculator(targetType, source, recorder), recorder);
    }

    public void addLateVariable(Variable var, StateRecorder recorder) throws Impossible {
        if (!this._lateVariables.contains(var)) {
            if (recorder != null) {
                recorder.record(() -> this._lateVariables.remove(var));
            }
            this._lateVariables.add(var);
        }
    }

    private boolean checkLateVariables() {
        return this._lateVariables.stream().allMatch(Variable::isComplete);
    }

    private boolean checkEarlyVariables() {
        return this._earlyVariables.stream().allMatch(Variable::isBound);
    }

    public boolean isConsistent() {
        return this.checkLateVariables() && this.checkEarlyVariables();
    }
}

