/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.NetNotFoundException;
import de.renew.net.loading.Finder;
import de.renew.net.loading.PathlessFinder;
import de.renew.shadow.SNSFinder;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowNetSystem;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultShadowNetLoader
implements ShadowNetLoader {
    public static Logger logger = Logger.getLogger(DefaultShadowNetLoader.class);
    private Set<Finder> finders = new LinkedHashSet<Finder>();
    private Set<PathlessFinder> pathlessFinders = new LinkedHashSet<PathlessFinder>();
    private PathEntry[] netSource;

    public DefaultShadowNetLoader(Properties props) {
        this.registerFinder(new SNSFinder());
        if (props != null) {
            this.configureNetPath(props);
        } else {
            this.configureNetPath(System.getProperties());
        }
    }

    public void configureNetPath(Properties props) {
        this.setNetPath(props.getProperty("de.renew.netPath", System.getProperty("user.dir")));
    }

    void setNetPath(String path) {
        this.setNetPath(StringUtil.splitPaths((String)path));
    }

    void setNetPath(String[] paths) {
        this.netSource = StringUtil.canonizePaths((String[])paths);
        for (int i = 0; i < this.netSource.length; ++i) {
            logger.debug((Object)("Shadow net loader source" + (this.netSource[i].isClasspathRelative ? " (relative to CLASSPATH): " : ": ") + this.netSource[i].path));
        }
    }

    public static String asPathString(PathEntry[] paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] == null) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(File.pathSeparator);
            }
            if (paths[i].isClasspathRelative) {
                buffer.append("CLASSPATH");
                if (!"".equals(paths[i].path)) {
                    buffer.append(File.separator);
                }
            }
            buffer.append(paths[i].path);
        }
        return buffer.toString();
    }

    @Override
    public ShadowNetSystem loadShadowNetSystem(String netName) throws NetNotFoundException {
        ShadowNetSystem loaded = this.findShadowNetSystemFile(netName);
        if (loaded != null) {
            return loaded;
        }
        throw new NetNotFoundException(netName);
    }

    @Override
    public ShadowNet loadShadowNet(String netName, ShadowNetSystem netSystem) throws NetNotFoundException {
        ShadowNetSystem foundNetSystem = this.loadShadowNetSystem(netName);
        ShadowNet foundNet = foundNetSystem.elements().iterator().next();
        if (foundNet != null && netName.equals(foundNet.getName())) {
            foundNet.switchNetSystem(netSystem);
            return foundNet;
        }
        throw new NetNotFoundException(netName);
    }

    public ShadowNetSystem findShadowNetSystemFile(String name) {
        ShadowNetSystem theNetSystem = null;
        for (PathlessFinder finder : this.pathlessFinders) {
            logger.debug((Object)("Searching for net " + name + " in pathless finder " + String.valueOf(finder)));
            theNetSystem = finder.findNetFile(name);
            if (theNetSystem == null || theNetSystem.elements().isEmpty()) continue;
            return theNetSystem;
        }
        for (int i = 0; i < this.netSource.length; ++i) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.netSource[i].path);
            if (!"".equals(this.netSource[i].path)) {
                buffer.append(File.separator);
            }
            buffer.append(name);
            String path = buffer.toString();
            for (Finder finder : this.finders) {
                logger.debug((Object)("Searching for net " + String.valueOf(buffer) + " in finder " + String.valueOf(finder)));
                theNetSystem = this.netSource[i].isClasspathRelative ? finder.findNetClasspathRel(name, path) : finder.findNetFile(name, path);
                if (theNetSystem == null || theNetSystem.elements().isEmpty()) continue;
                return theNetSystem;
            }
        }
        return null;
    }

    public boolean registerFinder(Finder finder) {
        return this.finders.add(finder);
    }

    public boolean removeFinder(Finder finder) {
        return this.finders.remove(finder);
    }

    public boolean registerPathlessFinder(PathlessFinder finder) {
        return this.pathlessFinders.add(finder);
    }

    public boolean removePathlessFinder(PathlessFinder finder) {
        return this.pathlessFinders.remove(finder);
    }
}

