/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TokenReserver;
import de.renew.net.arc.ArcRemoveBinder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Value;

public class InputArcBinder
extends ArcRemoveBinder {
    Variable delayVar;

    protected InputArcBinder(Variable variable, Variable delayVar, SimulatablePlaceInstance placeInstance) {
        super(variable, placeInstance);
        this.delayVar = delayVar;
    }

    private double getDelay() {
        Object timeObj = this.delayVar.getValue();
        if (timeObj instanceof Value) {
            timeObj = ((Value)timeObj).value;
        }
        if (timeObj instanceof Number) {
            return ((Number)timeObj).doubleValue();
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected boolean mayBind() {
        return Unify.isBound(this.delayVar);
    }

    @Override
    protected boolean possible(TokenReserver reserver, Object token) {
        double delay = this.getDelay();
        return delay != Double.POSITIVE_INFINITY && reserver.containsRemovableToken(this.placeInstance, token, delay);
    }

    @Override
    protected boolean remove(TokenReserver reserver, Object token) {
        double delay = this.getDelay();
        return delay != Double.POSITIVE_INFINITY && reserver.removeToken(this.placeInstance, token, delay);
    }

    @Override
    protected void unremove(TokenReserver reserver, Object token) {
        reserver.unremoveToken(this.placeInstance, token, this.getDelay());
    }
}

