/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.Searcher;
import de.renew.net.TokenReserver;
import de.renew.net.arc.FlexibleArcOccurrence;
import de.renew.unify.List;
import de.renew.unify.Unify;
import de.renew.util.Value;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

class FlexibleArcBinder
implements Binder {
    public static Logger logger = Logger.getLogger(FlexibleArcBinder.class);
    FlexibleArcOccurrence occurrence;

    FlexibleArcBinder(FlexibleArcOccurrence occurrence) {
        this.occurrence = occurrence;
    }

    @Override
    public int bindingBadness(Searcher searcher) {
        if (Unify.isBound(this.occurrence.tokenVar)) {
            return 1;
        }
        return 10000;
    }

    private void rememberSingleToken(Object tok) {
        this.occurrence.inTokens.addElement(Unify.copyBoundValue(tok));
    }

    @Override
    public void bind(Searcher searcher) {
        if (!Unify.isBound(this.occurrence.tokenVar)) {
            throw new RuntimeException("Flexible arc binder was invoked for an incomplete value.");
        }
        Object tokens = this.occurrence.tokenVar.getValue();
        this.occurrence.inTokens = new Vector();
        if (tokens != null) {
            if (tokens.getClass().isArray()) {
                Class<?> elementType = tokens.getClass().getComponentType();
                int n = Array.getLength(tokens);
                for (int i = 0; i < n; ++i) {
                    Object tok = null;
                    try {
                        tok = Array.get(tokens, i);
                        if (elementType.isPrimitive()) {
                            tok = new Value(tok);
                        }
                        if (this.occurrence.arc.forwardFunction != null) {
                            Object convertedToken = this.occurrence.arc.forwardFunction.function(tok);
                            if (this.occurrence.arc.backwardFunction != null) {
                                Object restoredToken = this.occurrence.arc.backwardFunction.function(convertedToken);
                                Unify.unify(tok, restoredToken, null);
                            }
                            tok = convertedToken;
                        }
                        this.rememberSingleToken(tok);
                        continue;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            } else if (tokens instanceof List) {
                List current = (List)tokens;
                while (!current.isNull()) {
                    this.rememberSingleToken(current.head());
                    if (current.tail() instanceof List) {
                        current = (List)current.tail();
                        continue;
                    }
                    break;
                }
            } else if (tokens instanceof Collection) {
                Collection coll = (Collection)tokens;
                Iterator i = coll.iterator();
                while (i.hasNext()) {
                    this.rememberSingleToken(i.next());
                }
            }
        }
        if (!this.occurrence.arc.isOutputArc() && this.occurrence.inTokens.size() > 0) {
            searcher.insertTriggerable(this.occurrence.placeInstance.triggerables());
        }
        boolean success = true;
        int maxOk = 0;
        TokenReserver tokenReserver = TokenReserver.getInstance(searcher);
        while (success && maxOk < this.occurrence.inTokens.size()) {
            try {
                success = tokenReserver.removeToken(this.occurrence.placeInstance, this.occurrence.inTokens.elementAt(maxOk), 0.0);
                if (!success) continue;
                ++maxOk;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                success = false;
            }
        }
        if (success) {
            searcher.search();
        }
        while (maxOk > 0) {
            tokenReserver.unremoveToken(this.occurrence.placeInstance, this.occurrence.inTokens.elementAt(--maxOk), 0.0);
        }
        this.occurrence.inTokens = null;
    }
}

