/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.net.TimeSetResult;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class TimeSet
implements Serializable {
    public static final TimeSet EMPTY = new TimeSet(null, 0.0, 0, null);
    public static final TimeSet ZERO = EMPTY.including(0.0);
    private TimeSet left;
    private double time;
    private TimeSet right;
    private int mult;
    private int height;
    private int size;
    private int uniqueSize;

    private TimeSet(TimeSet left, double time, int mult, TimeSet right) {
        if (mult == 0) {
            if (left != null || right != null || time != 0.0) {
                throw new RuntimeException("Bad empty time set parameters.");
            }
            this.left = null;
            this.right = null;
            this.mult = 0;
            this.time = 0.0;
            this.height = 0;
            this.size = 0;
            this.uniqueSize = 0;
        } else {
            int leftHeight = left.height;
            int rightHeight = right.height;
            int diff = leftHeight - rightHeight;
            if (diff >= 2) {
                int leftLeftHeight = left.left.height;
                int leftRightHeight = left.right.height;
                if (leftLeftHeight > leftRightHeight) {
                    this.left = left.left;
                    this.time = left.time;
                    this.mult = left.mult;
                    this.right = new TimeSet(left.right, time, mult, right);
                } else {
                    this.left = new TimeSet(left.left, left.time, left.mult, left.right.left);
                    this.time = left.right.time;
                    this.mult = left.right.mult;
                    this.right = new TimeSet(left.right.right, time, mult, right);
                }
            } else if (diff <= -2) {
                int rightRightHeight = right.right.height;
                int rightLeftHeight = right.left.height;
                if (rightRightHeight > rightLeftHeight) {
                    this.left = new TimeSet(left, time, mult, right.left);
                    this.time = right.time;
                    this.mult = right.mult;
                    this.right = right.right;
                } else {
                    this.left = new TimeSet(left, time, mult, right.left.left);
                    this.time = right.left.time;
                    this.mult = right.left.mult;
                    this.right = new TimeSet(right.left.right, right.time, right.mult, right.right);
                }
            } else {
                this.left = left;
                this.time = time;
                this.mult = mult;
                this.right = right;
            }
            this.height = Math.max(left.height, right.height) + 1;
            this.size = left.size + right.size + mult;
            this.uniqueSize = left.uniqueSize + right.uniqueSize + 1;
        }
    }

    public boolean isEmpty() {
        return this.mult == 0;
    }

    public static TimeSet make(double time, int mult) {
        return new TimeSet(EMPTY, time, mult, EMPTY);
    }

    public int getSize() {
        return this.size;
    }

    private TimeSet findNode(double searchTime) {
        TimeSet current = this;
        while (current.mult != 0) {
            if (current.time == searchTime) {
                return current;
            }
            if (current.time < searchTime) {
                current = current.right;
                continue;
            }
            current = current.left;
        }
        return EMPTY;
    }

    public int multiplicity(double searchTime) {
        return this.findNode((double)searchTime).mult;
    }

    public TimeSet including(double newTime) {
        return this.including(newTime, 1);
    }

    public TimeSet including(double newTime, int n) {
        TimeSet newRight;
        TimeSet newLeft;
        if (this.mult == 0) {
            return TimeSet.make(newTime, n);
        }
        if (newTime == this.time) {
            return new TimeSet(this.left, this.time, this.mult + n, this.right);
        }
        if (newTime < this.time) {
            newLeft = this.left.including(newTime, n);
            newRight = this.right;
        } else {
            newLeft = this.left;
            newRight = this.right.including(newTime, n);
        }
        return new TimeSet(newLeft, this.time, this.mult, newRight);
    }

    public TimeSet excluding(double oldTime) {
        int newMult;
        double newTime;
        TimeSet newRight;
        TimeSet newLeft;
        if (this.mult == 0) {
            throw new NoSuchElementException();
        }
        if (oldTime == this.time) {
            if (this.mult > 1) {
                newLeft = this.left;
                newRight = this.right;
                newTime = this.time;
                newMult = this.mult - 1;
            } else {
                if (this.right.mult == 0) {
                    return this.left;
                }
                if (this.left.mult == 0) {
                    return this.right;
                }
                TimeSetResult reordered = this.right.extractLeftmost();
                newLeft = this.left;
                newRight = reordered.tree;
                newTime = reordered.time;
                newMult = reordered.mult;
            }
        } else {
            if (oldTime < this.time) {
                newLeft = this.left.excluding(oldTime);
                newRight = this.right;
            } else {
                newLeft = this.left;
                newRight = this.right.excluding(oldTime);
            }
            newTime = this.time;
            newMult = this.mult;
        }
        return new TimeSet(newLeft, newTime, newMult, newRight);
    }

    private TimeSetResult extractLeftmost() {
        if (this.mult == 0) {
            throw new RuntimeException("Illegal invocation of extractLeftmost().");
        }
        if (this.left.mult == 0) {
            return new TimeSetResult(this.right, this.time, this.mult);
        }
        TimeSetResult lifted = this.left.extractLeftmost();
        return new TimeSetResult(new TimeSet(lifted.tree, this.time, this.mult, this.right), lifted.time, lifted.mult);
    }

    public double earliestTime() {
        TimeSet tree = this;
        while (tree.left.mult != 0) {
            tree = tree.left;
        }
        return tree.time;
    }

    public double latestTime() throws NoSuchElementException {
        TimeSet tree = this;
        if (this.mult == 0) {
            throw new NoSuchElementException();
        }
        while (tree.right.mult != 0) {
            tree = tree.right;
        }
        return tree.time;
    }

    public double latestWithDelay(double delay, double deadline) {
        TimeSet current = this;
        TimeSet best = null;
        while (current.mult != 0) {
            if (current.time + delay <= deadline) {
                best = current;
                current = current.right;
                continue;
            }
            current = current.left;
        }
        if (best != null) {
            return best.time;
        }
        throw new NoSuchElementException();
    }

    public double[] asUniqueArray() {
        double[] result = new double[this.uniqueSize];
        this.fillIn(result, 0, true);
        return result;
    }

    public double[] asArray() {
        double[] result = new double[this.size];
        this.fillIn(result, 0, false);
        return result;
    }

    private void fillIn(double[] result, int start, boolean unique) {
        if (this.mult == 0) {
            return;
        }
        this.left.fillIn(result, start, unique);
        if (unique) {
            start += this.left.uniqueSize;
            result[start++] = this.time;
        } else {
            start += this.left.size;
            for (int i = 0; i < this.mult; ++i) {
                result[start++] = this.time;
            }
        }
        this.right.fillIn(result, start, unique);
    }

    public double computeEarliestTime(TimeSet that) {
        return this.computeEarliestTime(that.asArray());
    }

    public double computeEarliestTime(double[] delays) {
        if (delays.length > this.size) {
            return Double.POSITIVE_INFINITY;
        }
        return this.computeEarliestTime(delays, delays.length - 1);
    }

    private double computeEarliestTime(double[] delays, int offset) {
        double earliest = Double.NEGATIVE_INFINITY;
        if (this.mult > 0) {
            earliest = this.left.computeEarliestTime(delays, offset);
            if ((offset -= this.left.size) >= 0) {
                earliest = Math.max(earliest, this.time + delays[offset]);
                if ((offset -= this.mult) >= 0) {
                    earliest = Math.max(earliest, this.right.computeEarliestTime(delays, offset));
                }
            }
        }
        return earliest;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TimeSet(");
        this.toString(buffer);
        buffer.append(')');
        return buffer.toString();
    }

    private void toString(StringBuffer buffer) {
        if (this.mult == 0) {
            return;
        }
        this.left.toString(buffer);
        for (int i = 0; i < this.mult; ++i) {
            buffer.append(' ');
            buffer.append(this.time);
        }
        this.right.toString(buffer);
    }
}

