/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.simulator.SimulationThreadPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TriggerableCollectionImpl
implements Serializable,
TriggerableCollection {
    private final Set<Triggerable> triggerables;

    public TriggerableCollectionImpl() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.triggerables = new HashSet<Triggerable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void include(Triggerable triggerable) {
        TriggerCollection triggers;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TriggerCollection triggerCollection = triggers = triggerable.triggers();
        synchronized (triggerCollection) {
            this.triggerables.add(triggerable);
            triggers.include(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void exclude(Triggerable triggerable) {
        TriggerCollection triggers;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TriggerCollection triggerCollection = triggers = triggerable.triggers();
        synchronized (triggerCollection) {
            this.triggerables.remove(triggerable);
            triggers.exclude(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proposeSearch() {
        ArrayList<Triggerable> list;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TriggerableCollectionImpl triggerableCollectionImpl = this;
        synchronized (triggerableCollectionImpl) {
            list = new ArrayList<Triggerable>(this.triggerables);
        }
        for (Triggerable triggerable : list) {
            triggerable.proposeSearch();
        }
    }
}

