/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.common;

import de.renew.engine.searcher.Binder;
import de.renew.engine.searcher.BindingBadness;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public abstract class AssignBinder
implements Binder {
    Variable variable;
    boolean checkBound;

    public AssignBinder(Variable variable, boolean checkBound) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this.variable = variable;
        this.checkBound = checkBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bindingBadness(Searcher searcher) {
        int result;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (Unify.isBound(this.variable)) {
            return 1;
        }
        this.lock();
        try {
            Collection<?> candidates = this.getCandidates(this.variable.getValue());
            result = BindingBadness.clip(candidates.size());
        }
        finally {
            this.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Searcher searcher) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (Unify.isBound(this.variable) && !this.checkBound) {
            searcher.search();
        } else {
            ArrayList candidates;
            TriggerableCollection triggerables = this.getTriggerables();
            if (triggerables != null) {
                searcher.insertTriggerable(triggerables);
            }
            this.lock();
            try {
                candidates = new ArrayList(this.getCandidates(this.variable.getValue()));
            }
            finally {
                this.unlock();
            }
            Collections.shuffle(candidates);
            Iterator values = candidates.iterator();
            while (values.hasNext() && !searcher.isCompleted()) {
                Object value = values.next();
                int checkpoint = searcher.recorder.checkpoint();
                try {
                    Unify.unify(this.variable, value, searcher.recorder);
                    searcher.search();
                }
                catch (Impossible impossible) {
                    // empty catch block
                }
                searcher.recorder.restore(checkpoint);
            }
        }
    }

    public abstract void lock();

    public abstract void unlock();

    public abstract Collection<?> getCandidates(Object var1);

    public abstract TriggerableCollection getTriggerables();
}

