/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.automatalib.visualization.dot.DOTMisc;
import net.automatalib.visualization.dot.ImageComponent;
import net.automatalib.visualization.dot.PlottedGraph;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOTPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DOTPanel.class);
    private static final long serialVersionUID = 1L;
    private final ImageComponent imgComponent;
    private final JList<PlottedGraph> listBox;
    private final DefaultListModel<PlottedGraph> graphs;
    private final Action saveDotAction;
    private final Action savePngAction;
    private final Action renameAction;
    private final Action clearAction;

    public DOTPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.imgComponent = new ImageComponent();
        JScrollPane scrollPane = new JScrollPane(this.imgComponent);
        this.add((Component)scrollPane, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.gridheight = 1;
        this.graphs = new DefaultListModel();
        this.listBox = new JList<PlottedGraph>(this.graphs);
        this.saveDotAction = new AbstractDisabledAction("Save DOT"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOTPanel.this.saveDOT();
            }
        };
        this.savePngAction = new AbstractDisabledAction("Save PNG"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOTPanel.this.savePNG();
            }
        };
        this.renameAction = new AbstractDisabledAction("Rename"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOTPanel.this.rename();
            }
        };
        this.clearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DOTPanel.this.clear();
            }
        };
        this.listBox.addListSelectionListener(e -> {
            boolean activeSelection;
            int idx = this.listBox.getSelectedIndex();
            boolean bl = activeSelection = idx != -1;
            if (!activeSelection) {
                this.imgComponent.setImage(null);
            } else {
                PlottedGraph pg = this.graphs.get(idx);
                this.imgComponent.setImage(pg.getImage());
            }
            this.saveDotAction.setEnabled(activeSelection);
            this.savePngAction.setEnabled(activeSelection);
            this.renameAction.setEnabled(activeSelection);
            scrollPane.validate();
        });
        this.add((Component)new JScrollPane(this.listBox), c);
        c.gridy = 1;
        c.weighty = 0.0;
        JButton savePngBtn = new JButton(this.savePngAction);
        this.add((Component)savePngBtn, c);
        c.gridy = 2;
        JButton saveDotBtn = new JButton(this.saveDotAction);
        this.add((Component)saveDotBtn, c);
    }

    public Action getSaveDotAction() {
        return this.saveDotAction;
    }

    public Action getSavePngAction() {
        return this.savePngAction;
    }

    public Action getRenameAction() {
        return this.renameAction;
    }

    public Action getClearAction() {
        return this.clearAction;
    }

    @RequiresNonNull(value={"listBox"})
    public void saveDOT(@UnknownInitialization(value=JPanel.class) DOTPanel this) {
        PlottedGraph pg = this.listBox.getSelectedValue();
        if (pg == null) {
            JOptionPane.showMessageDialog(this, "Cannot save DOT: No active graph!", "Cannot save DOT", 0);
            return;
        }
        JFileChooser saveDlg = new JFileChooser();
        saveDlg.setFileFilter(DOTMisc.DOT_FILTER);
        int result = saveDlg.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        try {
            pg.saveDot(saveDlg.getSelectedFile());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Could not save DOT file: " + e.getMessage(), "Cannot save DOT", 0);
        }
    }

    @RequiresNonNull(value={"listBox"})
    public void savePNG(@UnknownInitialization(value=JPanel.class) DOTPanel this) {
        PlottedGraph pg = this.listBox.getSelectedValue();
        if (pg == null) {
            JOptionPane.showMessageDialog(this, "Cannot save PNG: No active graph!", "Cannot save PNG", 0);
            return;
        }
        JFileChooser saveDlg = new JFileChooser();
        saveDlg.setFileFilter(DOTMisc.PNG_FILTER);
        File f = new File(saveDlg.getCurrentDirectory(), pg.getName() + ".png");
        saveDlg.setSelectedFile(f);
        int result = saveDlg.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        try {
            pg.savePng(saveDlg.getSelectedFile());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Could not save PNG file: " + e.getMessage(), "Cannot save PNG", 0);
        }
    }

    public void addGraph(String name, String dotText) {
        try {
            this.addGraph(name, new StringReader(dotText));
        }
        catch (IOException e) {
            LOGGER.error("Could not add graph", e);
        }
    }

    public void addGraph(String name, Reader dotText) throws IOException {
        PlottedGraph pg = new PlottedGraph(name, dotText);
        this.graphs.addElement(pg);
    }

    @RequiresNonNull(value={"graphs"})
    public void clear(@UnknownInitialization(value=JPanel.class) DOTPanel this) {
        this.graphs.clear();
    }

    @RequiresNonNull(value={"listBox"})
    public void rename(@UnknownInitialization(value=JPanel.class) DOTPanel this) {
        PlottedGraph pg = this.listBox.getSelectedValue();
        if (pg == null) {
            JOptionPane.showMessageDialog(this, "Cannot rename: No active graph!", "Cannot rename", 0);
            return;
        }
        String input = JOptionPane.showInputDialog(this, "Enter new name: ", "Enter name");
        if (input == null) {
            return;
        }
        pg.setName(input);
    }

    public Writer createDotWriter(String name) {
        return new DotWriter(name);
    }

    private static abstract class AbstractDisabledAction
    extends AbstractAction {
        AbstractDisabledAction(String name) {
            super(name);
            this.setEnabled(false);
        }
    }

    private final class DotWriter
    extends StringWriter {
        private final String name;

        DotWriter(String name) {
            this.name = name;
        }

        @Override
        public void close() throws IOException {
            DOTPanel.this.addGraph(this.name, this.getBuffer().toString());
            super.close();
        }
    }
}

