/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.partitionrefinement;

import java.util.Arrays;
import java.util.function.IntFunction;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.simple.SimpleDeterministicAutomaton;
import net.automatalib.commons.util.functions.BiIntFunction;
import net.automatalib.util.partitionrefinement.Block;
import net.automatalib.util.partitionrefinement.PaigeTarjan;
import net.automatalib.words.Alphabet;

public final class PaigeTarjanExtractors {
    private PaigeTarjanExtractors() {
    }

    public static <I, SP, TP, A extends MutableDeterministic<?, I, ?, SP, TP>> A toDeterministic(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, SimpleDeterministicAutomaton.FullIntAbstraction absOriginal, IntFunction<? extends SP> spExtractor, BiIntFunction<? extends TP> tpExtractor, boolean pruneUnreachable) {
        if (pruneUnreachable) {
            return PaigeTarjanExtractors.toDeterministicPruned(pt, creator, inputs, absOriginal, spExtractor, tpExtractor);
        }
        return PaigeTarjanExtractors.toDeterministicUnpruned(pt, creator, inputs, absOriginal, spExtractor, tpExtractor);
    }

    private static <I, SP, TP, A extends MutableDeterministic<?, I, ?, SP, TP>> A toDeterministicPruned(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, SimpleDeterministicAutomaton.FullIntAbstraction absOriginal, IntFunction<? extends SP> spExtractor, BiIntFunction<? extends TP> tpExtractor) {
        int numBlocks = pt.getNumBlocks();
        int numInputs = inputs.size();
        int[] repMap = new int[numBlocks];
        int[] stateMap = new int[numBlocks];
        Arrays.fill(stateMap, -1);
        MutableDeterministic result = (MutableDeterministic)creator.createAutomaton(inputs, numBlocks);
        UniversalDeterministicAutomaton.FullIntAbstraction resultAbs = result.fullIntAbstraction((Alphabet)inputs);
        int origInit = absOriginal.getIntInitialState();
        SP initSp = spExtractor.apply(origInit);
        int resInit = resultAbs.addIntInitialState(initSp);
        Block initBlock = pt.getBlockForState(origInit);
        stateMap[initBlock.id] = resInit;
        repMap[resInit] = origInit;
        int statesPtr = 0;
        int numStates = 1;
        while (statesPtr < numStates) {
            int resState = statesPtr++;
            int rep = repMap[resState];
            for (int i = 0; i < numInputs; ++i) {
                int succ = absOriginal.getSuccessor(rep, i);
                if (succ < 0) continue;
                TP tp = tpExtractor.apply(rep, i);
                Block succBlock = pt.getBlockForState(succ);
                int succBlockId = succBlock.id;
                int resSucc = stateMap[succBlockId];
                if (resSucc < 0) {
                    SP sp = spExtractor.apply(succ);
                    stateMap[succBlockId] = resSucc = resultAbs.addIntState(sp);
                    repMap[resSucc] = succ;
                    ++numStates;
                }
                resultAbs.setTransition(resState, i, resSucc, tp);
            }
        }
        return (A)result;
    }

    private static <I, T, SP, TP, A extends MutableDeterministic<?, I, ?, SP, TP>> A toDeterministicUnpruned(PaigeTarjan pt, AutomatonCreator<A, I> creator, Alphabet<I> inputs, SimpleDeterministicAutomaton.FullIntAbstraction absOriginal, IntFunction<? extends SP> spExtractor, BiIntFunction<? extends TP> tpExtractor) {
        int numBlocks = pt.getNumBlocks();
        int numInputs = inputs.size();
        MutableDeterministic result = (MutableDeterministic)creator.createAutomaton(inputs, numBlocks);
        UniversalDeterministicAutomaton.FullIntAbstraction resultAbs = result.fullIntAbstraction((Alphabet)inputs);
        for (int i = 0; i < numBlocks; ++i) {
            resultAbs.addIntState();
        }
        for (Block curr : pt.blockList()) {
            int blockId = curr.id;
            int rep = pt.getRepresentative(curr);
            SP sp = spExtractor.apply(rep);
            resultAbs.setStateProperty(blockId, sp);
            for (int i = 0; i < numInputs; ++i) {
                int succ = absOriginal.getSuccessor(rep, i);
                if (succ < 0) continue;
                int resSucc = pt.getBlockForState((int)succ).id;
                TP tp = tpExtractor.apply(rep, i);
                resultAbs.setTransition(blockId, i, resSucc, tp);
            }
        }
        int origInit = absOriginal.getIntInitialState();
        resultAbs.setInitialState(pt.getBlockForState((int)origInit).id);
        return (A)result;
    }
}

