/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.vpda;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.commons.smartcollections.ArrayStorage;
import net.automatalib.commons.util.Pair;
import net.automatalib.util.automata.vpda.OneSEVPAs;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class OneSEVPAUtil {
    private OneSEVPAUtil() {
    }

    public static <L, I> List<L> findReachableLocations(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.computeAccessSequences(sevpa, alphabet, (boolean)false, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findReachableLocations$0(java.lang.Object ), (Ljava/lang/Object;)Z)()).reachableLocs;
    }

    public static <L, I> ReachResult<L, I> computeAccessSequences(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet, boolean computeAs, Predicate<? super L> terminatePred) {
        ArrayStorage result = new ArrayStorage(sevpa.size());
        L initLoc = sevpa.getInitialLocation();
        ArrayList<L> reachable = new ArrayList<L>();
        reachable.add(initLoc);
        result.set(sevpa.getLocationId(initLoc), Word.epsilon());
        if (terminatePred.test(initLoc)) {
            return new ReachResult(initLoc, reachable, result);
        }
        int queuePtr = 0;
        while (queuePtr < reachable.size()) {
            Object curr = reachable.get(queuePtr++);
            Word currAs = result.get(sevpa.getLocationId(curr));
            for (Object intSym : alphabet.getInternalAlphabet()) {
                int succIdx;
                L succ = sevpa.getInternalSuccessor(curr, intSym);
                if (succ == null || result.get(succIdx = sevpa.getLocationId(succ)) != null) continue;
                Word succAs = computeAs ? currAs.append(intSym) : Word.epsilon();
                result.set(succIdx, succAs);
                if (terminatePred.test(succ)) {
                    return new ReachResult(succ, reachable, result);
                }
                reachable.add(succ);
            }
            for (Object callSym : alphabet.getCallAlphabet()) {
                for (Object returnSym : alphabet.getReturnAlphabet()) {
                    for (int i = 0; i < queuePtr; ++i) {
                        Word succAs;
                        Object src = reachable.get(i);
                        int stackSym = sevpa.encodeStackSym(src, callSym);
                        L succ = sevpa.getReturnSuccessor(curr, returnSym, stackSym);
                        if (succ == null) continue;
                        int succIdx = sevpa.getLocationId(succ);
                        if (result.get(succIdx) == null) {
                            succAs = computeAs ? result.get(sevpa.getLocationId(src)).append(callSym).concat(currAs.append(returnSym)) : Word.epsilon();
                            result.set(succIdx, succAs);
                            if (terminatePred.test(succ)) {
                                return new ReachResult(succ, reachable, result);
                            }
                            reachable.add(succ);
                        }
                        if (src == curr || (succ = sevpa.getReturnSuccessor(src, returnSym, stackSym = sevpa.encodeStackSym(curr, callSym))) == null || result.get(succIdx = sevpa.getLocationId(succ)) != null) continue;
                        succAs = computeAs ? currAs.append(callSym).concat(result.get(sevpa.getLocationId(src)).append(returnSym)) : Word.epsilon();
                        result.set(succIdx, succAs);
                        if (terminatePred.test(succ)) {
                            return new ReachResult(succ, reachable, result);
                        }
                        reachable.add(succ);
                    }
                }
            }
        }
        return new ReachResult(null, reachable, result);
    }

    public static <L, I> ArrayStorage<Word<I>> computeAccessSequences(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.computeAccessSequences(sevpa, alphabet, (boolean)true, (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$computeAccessSequences$1(java.lang.Object ), (Ljava/lang/Object;)Z)()).accessSequences;
    }

    public static <L, I> @Nullable Word<I> findRejectedWord(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.computeAccessSequence(sevpa, alphabet, l -> !sevpa.isAcceptingLocation(l));
    }

    public static <L, I> @Nullable Word<I> computeAccessSequence(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet, Predicate<? super L> predicate) {
        ReachResult<? super L, I> result = OneSEVPAUtil.computeAccessSequences(sevpa, alphabet, true, predicate);
        Object resultLoc = result.terminateLoc;
        if (resultLoc != null) {
            return result.accessSequences.get(sevpa.getLocationId(resultLoc));
        }
        return null;
    }

    public static <I> boolean testEquivalence(OneSEVPA<?, I> sevpa1, OneSEVPA<?, I> sevpa2, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.findSeparatingWord(sevpa1, sevpa2, alphabet) == null;
    }

    public static <I> @Nullable Word<I> findSeparatingWord(OneSEVPA<?, I> sevpa1, OneSEVPA<?, I> sevpa2, VPDAlphabet<I> alphabet) {
        OneSEVPA<Pair<?, ?>, I> prod = OneSEVPAs.xor(sevpa1, sevpa2, alphabet);
        return OneSEVPAUtil.findAcceptedWord(prod, alphabet);
    }

    public static <L, I> @Nullable Word<I> findAcceptedWord(OneSEVPA<L, I> sevpa, VPDAlphabet<I> alphabet) {
        return OneSEVPAUtil.computeAccessSequence(sevpa, alphabet, sevpa::isAcceptingLocation);
    }

    private static /* synthetic */ boolean lambda$computeAccessSequences$1(Object l) {
        return false;
    }

    private static /* synthetic */ boolean lambda$findReachableLocations$0(Object l) {
        return false;
    }

    public static class ReachResult<L, I> {
        public final @Nullable L terminateLoc;
        public final List<L> reachableLocs;
        public final ArrayStorage<Word<I>> accessSequences;

        public ReachResult(@Nullable L terminateLoc, List<L> reachableLocs, ArrayStorage<Word<I>> accessSequences) {
            this.terminateLoc = terminateLoc;
            this.reachableLocs = reachableLocs;
            this.accessSequences = accessSequences;
        }
    }
}

