/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.transducers;

import java.util.Collection;
import net.automatalib.automata.transducers.MutableMealyMachine;
import net.automatalib.util.automata.Automata;

public final class MutableMealyMachines {
    private MutableMealyMachines() {
        throw new IllegalStateException("Constructor should never be invoked");
    }

    public static <I, O> void complete(MutableMealyMachine<?, I, ?, O> mealy, Collection<? extends I> inputs, O undefinedOutput) {
        MutableMealyMachines.complete(mealy, inputs, undefinedOutput, false);
    }

    public static <S, I, O> void complete(MutableMealyMachine<S, I, ?, O> mealy, Collection<? extends I> inputs, O undefinedOutput, boolean minimize) {
        Object sink = null;
        for (Object state : mealy) {
            for (I input : inputs) {
                Object succ = mealy.getSuccessor(state, input);
                if (succ != null) continue;
                if (sink == null) {
                    sink = mealy.addState();
                    for (I inputSym : inputs) {
                        mealy.addTransition(sink, inputSym, sink, undefinedOutput);
                    }
                }
                mealy.addTransition(state, input, sink, undefinedOutput);
            }
        }
        if (minimize) {
            Automata.invasiveMinimize(mealy, inputs);
        }
    }
}

