/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelSerializationProvider;
import net.automatalib.serialization.taf.parser.PrintStreamDiagnosticListener;
import net.automatalib.serialization.taf.parser.TAFParser;
import net.automatalib.serialization.taf.writer.TAFWriter;
import net.automatalib.words.Alphabet;

public final class TAFSerializationDFA
implements InputModelSerializationProvider<String, DFA<?, String>, DFA<Integer, String>> {
    private static final TAFSerializationDFA INSTANCE = new TAFSerializationDFA();

    private TAFSerializationDFA() {
    }

    public static TAFSerializationDFA getInstance() {
        return INSTANCE;
    }

    @Override
    public void writeModel(OutputStream os, DFA<?, String> model, Alphabet<String> alphabet) throws IOException {
        try (Writer w = IOUtil.asBufferedNonClosingUTF8Writer(os);){
            TAFWriter.writeDFA(model, alphabet, w);
        }
    }

    @Override
    public InputModelData<String, DFA<Integer, String>> readModel(InputStream is) throws IOException {
        CompactDFA<String> automaton = TAFParser.parseDFA(is, PrintStreamDiagnosticListener.getStderrDiagnosticListener());
        return new InputModelData<String, DFA<Integer, String>>(automaton, automaton.getInputAlphabet());
    }
}

