/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.etf.writer;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.Pair;
import net.automatalib.serialization.etf.writer.AbstractETFWriter;
import net.automatalib.words.Alphabet;

public final class Mealy2ETFWriterAlternating<I, O>
extends AbstractETFWriter<I, MealyMachine<?, I, ?, O>> {
    private static final Mealy2ETFWriterAlternating<?, ?> INSTANCE = new Mealy2ETFWriterAlternating();

    @Override
    protected void writeEdge(PrintWriter pw) {
        pw.println("begin edge");
        pw.println("letter:letter");
        pw.println("end edge");
    }

    @Override
    protected void writeETF(PrintWriter pw, MealyMachine<?, I, ?, O> mealy, Alphabet<I> inputs) {
        this.writeETFInternal(pw, mealy, inputs);
    }

    private <S, T> void writeETFInternal(PrintWriter pw, MealyMachine<S, I, T, O> mealy, Alphabet<I> inputs) {
        int i2;
        HashBiMap oldStates = HashBiMap.create();
        mealy.getStates().forEach(s2 -> oldStates.put(s2, oldStates.size()));
        pw.println("begin init");
        pw.printf("%d%n", oldStates.get(mealy.getInitialState()));
        pw.println("end init");
        HashBiMap<Pair, Integer> outputTransitions = HashBiMap.create();
        HashBiMap outputIndices = HashBiMap.create();
        pw.println("begin trans");
        for (Object s3 : mealy.getStates()) {
            for (Object i3 : inputs) {
                Object t = mealy.getTransition(s3, i3);
                if (t == null) continue;
                Object n = mealy.getSuccessor(t);
                Object o = mealy.getTransitionOutput(t);
                Pair outputTransition = Pair.of(o, n);
                Integer intermediateState = outputTransitions.computeIfAbsent(outputTransition, ii -> {
                    Integer outputIndex = outputIndices.computeIfAbsent(o, iii -> inputs.size() + outputIndices.size());
                    Integer res = oldStates.size() + outputTransitions.size();
                    pw.printf("%d/%d %d%n", res, oldStates.get(n), outputIndex);
                    return res;
                });
                pw.printf("%d/%d %d%n", oldStates.get(s3), intermediateState, inputs.getSymbolIndex(i3));
            }
        }
        pw.println("end trans");
        pw.println("begin sort id");
        for (int i4 = 0; i4 < oldStates.size(); ++i4) {
            pw.printf("\"%s\"%n", oldStates.inverse().get(i4));
        }
        BiMap inverseTransitions = outputTransitions.inverse();
        for (i2 = 0; i2 < outputTransitions.size(); ++i2) {
            Pair t = (Pair)inverseTransitions.get(oldStates.size() + i2);
            assert (t != null);
            pw.printf("\"(%s,%s)\"%n", String.valueOf(t.getFirst()), String.valueOf(t.getSecond()));
        }
        pw.println("end sort");
        pw.println("begin sort letter");
        inputs.forEach(i -> pw.printf("\"%s\"%n", i));
        for (i2 = 0; i2 < outputIndices.size(); ++i2) {
            pw.printf("\"%s\"%n", outputIndices.inverse().get(inputs.size() + i2));
        }
        pw.println("end sort");
    }

    @Override
    public void writeModel(OutputStream os, MealyMachine<?, I, ?, O> model, Alphabet<I> alphabet) {
        try (PrintWriter pw = new PrintWriter(IOUtil.asBufferedNonClosingUTF8Writer(os));){
            this.write(pw, model, alphabet);
        }
    }

    public static <I, O> Mealy2ETFWriterAlternating<I, O> getInstance() {
        return INSTANCE;
    }
}

