/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSmin;
import net.automatalib.modelchecking.ModelChecker;
import net.automatalib.serialization.etf.writer.DFA2ETFWriter;
import net.automatalib.util.automata.copy.AutomatonCopyMethod;
import net.automatalib.util.automata.copy.AutomatonLowLevelCopy;
import net.automatalib.util.automata.fsa.DFAs;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;

public interface LTSminDFA<I, R>
extends LTSmin<I, DFA<?, I>, R>,
ModelChecker.DFAModelChecker<I, String, R> {
    public static final String LABEL_NAME = "label";
    public static final String LABEL_VALUE = "accept";

    @Override
    default public void automaton2ETF(DFA<?, I> automaton, Collection<? extends I> inputs, File etf) throws IOException {
        this.dfa2ETF(automaton, inputs, etf);
    }

    default public <S> void dfa2ETF(DFA<S, I> dfa, Collection<? extends I> inputs, File etf) throws IOException {
        if (DFAs.acceptsEmptyLanguage(dfa)) {
            throw new ModelCheckingException("DFA accepts the empty language, the LTS for such a DFA is not defined.");
        }
        Alphabet<? extends I> alphabet = Alphabets.fromCollection(inputs);
        if (!DFAs.isPrefixClosed(dfa, alphabet)) {
            throw new ModelCheckingException("DFA is not prefix closed.");
        }
        CompactDFA<? extends I> copy = new CompactDFA<I>(alphabet, dfa.size());
        AutomatonLowLevelCopy.copy(AutomatonCopyMethod.STATE_BY_STATE, dfa, inputs, copy, dfa::isAccepting, (s2, i, t) -> true);
        DFA2ETFWriter.getInstance().writeModel(etf, copy, alphabet);
    }
}

