/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.automatalib.graphs.IndefiniteSimpleGraph;

public interface IndefiniteGraph<N, E>
extends IndefiniteSimpleGraph<N> {
    @Override
    default public Iterator<N> adjacentTargetsIterator(N node) {
        return Iterators.transform(this.outgoingEdgesIterator(node), this::getTarget);
    }

    @Override
    default public Collection<N> getAdjacentTargets(N node) {
        return this.adjacentTargetsStream(node).collect(Collectors.toList());
    }

    @Override
    default public Stream<N> adjacentTargetsStream(N node) {
        return this.outgoingEdgesStream(node).map(this::getTarget);
    }

    @Override
    default public IndefiniteGraph<N, E> asNormalGraph() {
        return this;
    }

    default public Stream<E> outgoingEdgesStream(N node) {
        return this.getOutgoingEdges(node).stream();
    }

    default public Iterator<E> outgoingEdgesIterator(N node) {
        return this.getOutgoingEdges(node).iterator();
    }

    public Collection<E> getOutgoingEdges(N var1);

    default public Iterable<E> outgoingEdges(N node) {
        return () -> this.outgoingEdgesIterator(node);
    }

    default public Collection<E> getEdgesBetween(N from, N to) {
        return this.getOutgoingEdges(from).stream().filter(e -> Objects.equals(this.getTarget(e), to)).collect(Collectors.toList());
    }

    public N getTarget(E var1);
}

