/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.mappings;

import org.checkerframework.checker.index.qual.NonNegative;

public final class StringIndexMapping {
    private static final int ALPHABET_SIZE = 26;
    private static final char BASE = 'a';

    private StringIndexMapping() {
    }

    public static long stringToIndex(String sidx) {
        long idx = 0L;
        long value = 1L;
        for (int i = 0; i < sidx.length(); ++i) {
            char c = sidx.charAt(i);
            idx += value * (long)StringIndexMapping.getInteger(c);
            value *= 26L;
        }
        return idx;
    }

    public static String indexToString(@NonNegative long idx) {
        StringBuilder sb = new StringBuilder();
        long idxIter = idx;
        do {
            sb.append(StringIndexMapping.getChar((int)idxIter % 26));
        } while ((idxIter /= 26L) > 0L);
        return sb.toString();
    }

    private static int getInteger(char c) {
        return Character.toLowerCase(c) - 97;
    }

    private static char getChar(int idx) {
        return (char)(97 + idx);
    }
}

