/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AllTuplesIterator<T>
implements Iterator<List<T>> {
    private final Iterable<? extends T> iterable;
    private final List<T> current;
    private final @Nullable Iterator<? extends T>[] iterators;
    private boolean firstEmpty;

    AllTuplesIterator(Iterable<? extends T> iterable, int minLength, int maxLength) {
        if (maxLength < minLength || minLength < 0) {
            throw new IllegalArgumentException();
        }
        this.current = new ArrayList<T>(maxLength);
        this.iterators = new Iterator[maxLength];
        this.iterable = iterable;
        for (int i = 1; i < minLength; ++i) {
            Iterator<T> it = iterable.iterator();
            this.iterators[i] = it;
            this.current.add(it.next());
        }
        this.firstEmpty = minLength == 0;
    }

    @Override
    public boolean hasNext() {
        if (this.firstEmpty) {
            return true;
        }
        for (Iterator<T> iterator : this.iterators) {
            if (iterator != null && !iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> next() {
        if (this.firstEmpty) {
            this.firstEmpty = false;
            return this.current;
        }
        for (int i = 0; i < this.iterators.length; ++i) {
            Iterator<T> it = this.iterators[i];
            if (it == null) {
                it = this.iterable.iterator();
                this.iterators[i] = it;
                this.current.add(it.next());
                return this.current;
            }
            if (it.hasNext()) {
                this.current.set(i, it.next());
                return this.current;
            }
            it = this.iterable.iterator();
            this.iterators[i] = it;
            this.current.set(i, it.next());
        }
        throw new NoSuchElementException();
    }
}

