/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import net.automatalib.commons.smartcollections.ArrayUtil;
import net.automatalib.commons.smartcollections.CapacityManagement;

public final class ResizingArrayStorage<T>
implements CapacityManagement,
Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    public T[] array;
    private int nextCapacityHint;

    public ResizingArrayStorage(Class<? super T> arrayClazz) {
        this(arrayClazz, 10);
    }

    public ResizingArrayStorage(Class<? super T> arrayClazz, int initialCapacity) {
        this.array = (Object[])Array.newInstance(arrayClazz, Math.max(0, initialCapacity));
    }

    public ResizingArrayStorage(ResizingArrayStorage<T> other) {
        this.array = (Object[])other.array.clone();
        this.nextCapacityHint = other.nextCapacityHint;
    }

    @Override
    public boolean ensureCapacity(int minCapacity) {
        if (minCapacity <= this.array.length) {
            return false;
        }
        int newCapacity = ArrayUtil.computeNewCapacity(this.array.length, minCapacity, this.nextCapacityHint);
        this.array = Arrays.copyOf(this.array, newCapacity);
        this.nextCapacityHint = 0;
        return true;
    }

    @Override
    public boolean ensureAdditionalCapacity(int additionalCapacity) {
        return this.ensureCapacity(this.array.length + additionalCapacity);
    }

    @Override
    public void hintNextCapacity(int nextCapacityHint) {
        this.nextCapacityHint = nextCapacityHint;
    }

    public boolean shrink(int maxCapacity) {
        if (maxCapacity >= this.array.length) {
            return false;
        }
        this.array = Arrays.copyOf(this.array, maxCapacity);
        return true;
    }

    public void setAll(T value) {
        Arrays.fill(this.array, value);
    }

    public void swap(ResizingArrayStorage<T> other) {
        Class<?> otherType;
        Class<?> myType = this.array.getClass().getComponentType();
        if (myType != (otherType = other.array.getClass().getComponentType())) {
            throw new IllegalArgumentException("Cannot swap array storages of different array classes (" + myType + " vs. " + otherType + ")");
        }
        T[] arrayTmp = this.array;
        int hintTmp = this.nextCapacityHint;
        this.array = other.array;
        this.nextCapacityHint = other.nextCapacityHint;
        other.array = arrayTmp;
        other.nextCapacityHint = hintTmp;
    }
}

