/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.visualization;

import java.util.Map;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.automata.transducers.TransitionOutputAutomaton;
import net.automatalib.automata.visualization.AutomatonVisualizationHelper;

public class MealyVisualizationHelper<S, I, T, O>
extends AutomatonVisualizationHelper<S, I, T, TransitionOutputAutomaton<S, I, T, O>> {
    public MealyVisualizationHelper(TransitionOutputAutomaton<S, I, T, O> automaton) {
        super(automaton);
    }

    @Override
    public boolean getEdgeProperties(S src, TransitionEdge<I, T> edge, S tgt, Map<String, String> properties) {
        if (!super.getEdgeProperties(src, edge, tgt, properties)) {
            return false;
        }
        StringBuilder labelBuilder = new StringBuilder();
        labelBuilder.append(String.valueOf(edge.getInput())).append(" / ");
        Object output = ((TransitionOutputAutomaton)this.automaton).getTransitionOutput(edge.getTransition());
        if (output != null) {
            labelBuilder.append(String.valueOf(output));
        }
        properties.put("label", labelBuilder.toString());
        return true;
    }
}

