/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.visualization;

import java.util.Collection;
import java.util.Map;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.graphs.TransitionEdge;
import net.automatalib.visualization.DefaultVisualizationHelper;

public class AutomatonVisualizationHelper<S, I, T, A extends Automaton<S, I, T>>
extends DefaultVisualizationHelper<S, TransitionEdge<I, T>> {
    protected final A automaton;

    public AutomatonVisualizationHelper(A automaton) {
        this.automaton = automaton;
    }

    @Override
    protected Collection<S> initialNodes() {
        return this.automaton.getInitialStates();
    }

    @Override
    public boolean getEdgeProperties(S src, TransitionEdge<I, T> edge, S tgt, Map<String, String> properties) {
        if (!super.getEdgeProperties(src, edge, tgt, properties)) {
            return false;
        }
        String label = String.valueOf(edge.getInput());
        properties.put("label", label);
        return true;
    }
}

