/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.fast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.automata.base.fast.AbstractFastMutable;
import net.automatalib.automata.base.fast.AbstractFastState;
import net.automatalib.ts.powerset.FastPowersetDTS;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractFastMutableNondet<S extends AbstractFastState<Collection<T>>, I, T, SP, TP>
extends AbstractFastMutable<S, I, T, SP, TP> {
    private final Set<S> initialStates = new HashSet<S>();

    public AbstractFastMutableNondet(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public Set<S> getInitialStates() {
        return this.initialStates;
    }

    @Override
    public Collection<T> getTransitions(S state, I input) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        Collection result = (Collection)((AbstractFastState)state).getTransitionObject(inputIdx);
        return result == null ? Collections.emptySet() : result;
    }

    @Override
    public void clear() {
        super.clear();
        this.initialStates.clear();
    }

    @Override
    public void setInitial(S state, boolean initial) {
        if (initial) {
            this.initialStates.add(state);
        } else {
            this.initialStates.remove(state);
        }
    }

    @Override
    public void setTransitions(S state, I input, Collection<? extends T> transitions) {
        int inputIdx = this.inputAlphabet.getSymbolIndex(input);
        ((AbstractFastState)state).setTransitionObject(inputIdx, new HashSet<T>(transitions));
    }

    @Override
    public void removeState(S state, @Nullable S replacement) {
        super.removeState(state, replacement);
        if (this.initialStates.remove(state) && replacement != null) {
            this.initialStates.add(replacement);
        }
    }

    public FastPowersetDTS<S, I, T> powersetView() {
        return new FastPowersetDTS(this);
    }

    @Override
    public Collection<I> getLocalInputs(S state) {
        Alphabet alphabet = this.getInputAlphabet();
        int alphabetSize = alphabet.size();
        ArrayList result = new ArrayList(alphabetSize);
        for (int i = 0; i < alphabetSize; ++i) {
            Collection trans = (Collection)((AbstractFastState)state).getTransitionObject(i);
            if (trans == null || trans.isEmpty()) continue;
            result.add(alphabet.getSymbol(i));
        }
        return result;
    }
}

