/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata;

import java.util.Collection;
import java.util.Objects;
import java.util.function.IntFunction;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface MutableDeterministic<S, I, T, SP, TP>
extends UniversalDeterministicAutomaton<S, I, T, SP, TP>,
MutableAutomaton<S, I, T, SP, TP> {
    @Override
    default public void setInitial(S state, boolean initial) {
        Object currInitial = this.getInitialState();
        boolean equal = Objects.equals(state, currInitial);
        if (initial) {
            if (currInitial == null) {
                this.setInitialState(state);
            } else if (!equal) {
                throw new IllegalStateException("Cannot set state '" + state + "' as additional initial state (current initial state: '" + currInitial + "'.");
            }
        } else if (equal) {
            this.setInitialState(null);
        }
    }

    @Override
    default public void setTransitions(S state, I input, Collection<? extends T> transitions) {
        int num = transitions.size();
        if (num > 1) {
            throw new IllegalArgumentException("Deterministic automaton can not have multiple transitions for the same input symbol.");
        }
        T trans = num > 0 ? (T)transitions.iterator().next() : null;
        this.setTransition(state, input, trans);
    }

    @Override
    default public void removeTransition(S state, I input, T transition) {
        if (transition == null) {
            return;
        }
        Object currTrans = this.getTransition(state, input);
        if (transition.equals(currTrans)) {
            this.setTransition(state, input, null);
        }
    }

    @Override
    default public void removeAllTransitions(S state, I input) {
        this.setTransition(state, input, null);
    }

    @Override
    default public void addTransition(S state, I input, T transition) {
        Object currTrans = this.getTransition(state, input);
        if (currTrans != null) {
            throw new IllegalStateException("Cannot add transition " + transition + " to deterministic automaton: transition already defined for state " + state + " and input " + input + ".");
        }
        this.setTransition(state, input, transition);
    }

    public void setInitialState(@Nullable S var1);

    public void setTransition(S var1, I var2, @Nullable T var3);

    default public void setTransition(S state, I input, @Nullable S successor, TP property) {
        if (successor != null) {
            Object trans = this.createTransition(successor, property);
            this.setTransition(state, input, trans);
        }
    }

    @Override
    default public FullIntAbstraction<T, SP, TP> fullIntAbstraction(Alphabet<I> alphabet) {
        return this.fullIntAbstraction(alphabet.size(), alphabet);
    }

    @Override
    default public FullIntAbstraction<T, SP, TP> fullIntAbstraction(int numInputs, IntFunction<? extends I> symMapping) {
        return new FullIntAbstraction.DefaultAbstraction(this.stateIntAbstraction(), numInputs, symMapping);
    }

    @Override
    default public StateIntAbstraction<I, T, SP, TP> stateIntAbstraction() {
        return new StateIntAbstraction.DefaultAbstraction(this);
    }

    public static interface FullIntAbstraction<T, SP, TP>
    extends IntAbstraction<T, SP, TP>,
    UniversalDeterministicAutomaton.FullIntAbstraction<T, SP, TP> {
        public void setTransition(int var1, int var2, @Nullable T var3);

        public void setTransition(int var1, int var2, int var3, TP var4);

        public static class DefaultAbstraction<I, T, SP, TP, A extends StateIntAbstraction<I, T, SP, TP>>
        extends UniversalDeterministicAutomaton.FullIntAbstraction.DefaultAbstraction<I, T, SP, TP, A>
        implements FullIntAbstraction<T, SP, TP> {
            public DefaultAbstraction(A stateAbstraction, int numInputs, IntFunction<? extends I> symMapping) {
                super(stateAbstraction, numInputs, symMapping);
            }

            @Override
            public void setTransition(int state, int input, @Nullable T transition) {
                ((StateIntAbstraction)this.stateAbstraction).setTransition(state, this.intToSym(input), transition);
            }

            @Override
            public void setTransition(int state, int input, int successor, TP property) {
                ((StateIntAbstraction)this.stateAbstraction).setTransition(state, this.intToSym(input), successor, property);
            }

            @Override
            public void setStateProperty(int state, SP property) {
                ((StateIntAbstraction)this.stateAbstraction).setStateProperty(state, property);
            }

            @Override
            public void setTransitionProperty(T transition, TP property) {
                ((StateIntAbstraction)this.stateAbstraction).setTransitionProperty(transition, property);
            }

            @Override
            public void setInitialState(int state) {
                ((StateIntAbstraction)this.stateAbstraction).setInitialState(state);
            }

            @Override
            public T createTransition(int successor, TP property) {
                return ((StateIntAbstraction)this.stateAbstraction).createTransition(successor, property);
            }

            @Override
            public int addIntState() {
                return ((StateIntAbstraction)this.stateAbstraction).addIntState();
            }

            @Override
            public int addIntState(@Nullable SP property) {
                return ((StateIntAbstraction)this.stateAbstraction).addIntState(property);
            }

            @Override
            public int addIntInitialState() {
                return ((StateIntAbstraction)this.stateAbstraction).addIntInitialState();
            }

            @Override
            public int addIntInitialState(@Nullable SP property) {
                return ((StateIntAbstraction)this.stateAbstraction).addIntInitialState(property);
            }
        }
    }

    public static interface StateIntAbstraction<I, T, SP, TP>
    extends IntAbstraction<T, SP, TP>,
    UniversalDeterministicAutomaton.StateIntAbstraction<I, T, SP, TP> {
        public void setTransition(int var1, I var2, @Nullable T var3);

        public void setTransition(int var1, I var2, int var3, TP var4);

        public static class DefaultAbstraction<S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>>
        extends UniversalDeterministicAutomaton.StateIntAbstraction.DefaultAbstraction<S, I, T, SP, TP, A>
        implements StateIntAbstraction<I, T, SP, TP> {
            public DefaultAbstraction(A automaton) {
                super(automaton);
            }

            @Override
            public void setStateProperty(int state, SP property) {
                ((MutableDeterministic)this.automaton).setStateProperty(this.intToState(state), property);
            }

            @Override
            public void setTransition(int state, I input, @Nullable T transition) {
                ((MutableDeterministic)this.automaton).setTransition(this.intToState(state), input, transition);
            }

            @Override
            public void setTransition(int state, I input, int successor, TP property) {
                ((MutableDeterministic)this.automaton).setTransition(this.intToState(state), input, this.safeIntToState(successor), property);
            }

            @Override
            public void setTransitionProperty(T transition, TP property) {
                ((MutableDeterministic)this.automaton).setTransitionProperty(transition, property);
            }

            @Override
            public void setInitialState(int state) {
                ((MutableDeterministic)this.automaton).setInitialState(this.safeIntToState(state));
            }

            @Override
            public T createTransition(int successor, TP property) {
                return ((MutableDeterministic)this.automaton).createTransition(this.intToState(successor), property);
            }

            @Override
            public int addIntState() {
                return this.stateToInt(((MutableDeterministic)this.automaton).addState());
            }

            @Override
            public int addIntState(@Nullable SP property) {
                return this.stateToInt(((MutableDeterministic)this.automaton).addState(property));
            }

            @Override
            public int addIntInitialState() {
                return this.stateToInt(((MutableDeterministic)this.automaton).addInitialState());
            }

            @Override
            public int addIntInitialState(@Nullable SP property) {
                return this.stateToInt(((MutableDeterministic)this.automaton).addInitialState(property));
            }
        }
    }

    public static interface IntAbstraction<T, SP, TP>
    extends UniversalDeterministicAutomaton.IntAbstraction<T, SP, TP> {
        public void setStateProperty(int var1, SP var2);

        public void setTransitionProperty(T var1, TP var2);

        public void setInitialState(int var1);

        public T createTransition(int var1, TP var2);

        default public int addIntState() {
            return this.addIntState(null);
        }

        public int addIntState(@Nullable SP var1);

        default public int addIntInitialState() {
            return this.addIntInitialState(null);
        }

        public int addIntInitialState(@Nullable SP var1);
    }
}

