/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class BasicVertexRenderer<V, E>
implements Renderer.Vertex<V, E> {
    @Override
    public void paintVertex(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        Graph<V, E> graph = layout.getGraph();
        if (rc.getVertexIncludePredicate().apply(Context.getInstance(graph, v))) {
            this.paintIconForVertex(rc, v, layout);
        }
    }

    protected Shape prepareFinalVertexShape(RenderContext<V, E> rc, V v, Layout<V, E> layout, int[] coords) {
        Shape shape = rc.getVertexShapeTransformer().apply(v);
        Point2D p = (Point2D)layout.apply(v);
        p = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
        float x = (float)p.getX();
        float y = (float)p.getY();
        coords[0] = (int)x;
        coords[1] = (int)y;
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        shape = xform.createTransformedShape(shape);
        return shape;
    }

    protected void paintIconForVertex(RenderContext<V, E> rc, V v, Layout<V, E> layout) {
        GraphicsDecorator g2 = rc.getGraphicsContext();
        boolean vertexHit = true;
        int[] coords = new int[2];
        Shape shape = this.prepareFinalVertexShape(rc, v, layout, coords);
        vertexHit = this.vertexHit(rc, shape);
        if (vertexHit) {
            if (rc.getVertexIconTransformer() != null) {
                Icon icon = rc.getVertexIconTransformer().apply(v);
                if (icon != null) {
                    g2.draw(icon, rc.getScreenDevice(), shape, coords[0], coords[1]);
                } else {
                    this.paintShapeForVertex(rc, v, shape);
                }
            } else {
                this.paintShapeForVertex(rc, v, shape);
            }
        }
    }

    protected boolean vertexHit(RenderContext<V, E> rc, Shape s2) {
        MutableTransformer vt;
        JComponent vv = rc.getScreenDevice();
        Rectangle deviceRectangle = null;
        if (vv != null) {
            Dimension d = vv.getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        if ((vt = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW)) instanceof MutableTransformerDecorator) {
            vt = ((MutableTransformerDecorator)vt).getDelegate();
        }
        return vt.transform(s2).intersects(deviceRectangle);
    }

    protected void paintShapeForVertex(RenderContext<V, E> rc, V v, Shape shape) {
        Paint drawPaint;
        GraphicsDecorator g2 = rc.getGraphicsContext();
        Paint oldPaint = g2.getPaint();
        Paint fillPaint = rc.getVertexFillPaintTransformer().apply(v);
        if (fillPaint != null) {
            g2.setPaint(fillPaint);
            g2.fill(shape);
            g2.setPaint(oldPaint);
        }
        if ((drawPaint = rc.getVertexDrawPaintTransformer().apply(v)) != null) {
            g2.setPaint(drawPaint);
            Stroke oldStroke = g2.getStroke();
            Stroke stroke = rc.getVertexStrokeTransformer().apply(v);
            if (stroke != null) {
                g2.setStroke(stroke);
            }
            g2.draw(shape);
            g2.setPaint(oldPaint);
            g2.setStroke(oldStroke);
        }
    }
}

