/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.control.CubicCurveEdgeEffects;
import edu.uci.ics.jung.visualization.control.EdgeEffects;
import edu.uci.ics.jung.visualization.control.EdgeSupport;
import java.awt.geom.Point2D;

public class SimpleEdgeSupport<V, E>
implements EdgeSupport<V, E> {
    protected Point2D down;
    protected EdgeEffects<V, E> edgeEffects;
    protected EdgeType edgeType;
    protected Supplier<E> edgeFactory;
    protected V startVertex;

    public SimpleEdgeSupport(Supplier<E> edgeFactory) {
        this.edgeFactory = edgeFactory;
        this.edgeEffects = new CubicCurveEdgeEffects();
    }

    @Override
    public void startEdgeCreate(BasicVisualizationServer<V, E> vv, V startVertex, Point2D startPoint, EdgeType edgeType) {
        this.startVertex = startVertex;
        this.down = startPoint;
        this.edgeType = edgeType;
        this.edgeEffects.startEdgeEffects(vv, startPoint, startPoint);
        if (edgeType == EdgeType.DIRECTED) {
            this.edgeEffects.startArrowEffects(vv, startPoint, startPoint);
        }
        vv.repaint();
    }

    @Override
    public void midEdgeCreate(BasicVisualizationServer<V, E> vv, Point2D midPoint) {
        if (this.startVertex != null) {
            this.edgeEffects.midEdgeEffects(vv, this.down, midPoint);
            if (this.edgeType == EdgeType.DIRECTED) {
                this.edgeEffects.midArrowEffects(vv, this.down, midPoint);
            }
            vv.repaint();
        }
    }

    @Override
    public void endEdgeCreate(BasicVisualizationServer<V, E> vv, V endVertex) {
        if (this.startVertex != null) {
            Graph<V, E> graph = vv.getGraphLayout().getGraph();
            graph.addEdge(this.edgeFactory.get(), this.startVertex, endVertex, this.edgeType);
            vv.repaint();
        }
        this.startVertex = null;
        this.edgeType = EdgeType.UNDIRECTED;
        this.edgeEffects.endEdgeEffects(vv);
        this.edgeEffects.endArrowEffects(vv);
    }

    public EdgeEffects<V, E> getEdgeEffects() {
        return this.edgeEffects;
    }

    public void setEdgeEffects(EdgeEffects<V, E> edgeEffects) {
        this.edgeEffects = edgeEffects;
    }

    public EdgeType getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(EdgeType edgeType) {
        this.edgeType = edgeType;
    }

    public Supplier<E> getEdgeFactory() {
        return this.edgeFactory;
    }

    public void setEdgeFactory(Supplier<E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }
}

