/*
 * Decompiled with CFR 0.152.
 */
package com.github.misberner.graphvizawtshapes.shapes;

import java.awt.geom.PathIterator;
import java.util.Arrays;
import java.util.Iterator;

final class PathIteratorConcatenation
implements PathIterator {
    private final Iterator<? extends PathIterator> pathIts;
    private PathIterator current = null;

    private void advance() {
        while (this.current == null || this.current.isDone()) {
            if (!this.pathIts.hasNext()) {
                this.current = null;
                break;
            }
            this.current = this.pathIts.next();
        }
    }

    public PathIteratorConcatenation(PathIterator ... pathIts) {
        this(Arrays.asList(pathIts));
    }

    public PathIteratorConcatenation(Iterator<? extends PathIterator> pathIts) {
        this.pathIts = pathIts;
        this.advance();
    }

    public PathIteratorConcatenation(Iterable<? extends PathIterator> pathIts) {
        this(pathIts.iterator());
    }

    @Override
    public int getWindingRule() {
        return this.current.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.current == null;
    }

    @Override
    public void next() {
        this.current.next();
        this.advance();
    }

    @Override
    public int currentSegment(float[] coords) {
        return this.current.currentSegment(coords);
    }

    @Override
    public int currentSegment(double[] coords) {
        return this.current.currentSegment(coords);
    }
}

