/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.FilesystemController;
import de.renew.navigator.NavigatorExtension;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.gui.DefaultFileTreeCellRenderer;
import de.renew.navigator.gui.NavigatorGuiImpl;
import de.renew.navigator.models.TreeElement;
import de.renew.windowmanagement.Workbench;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class NavigatorGuiProxy
implements NavigatorGui {
    private final FilesystemController _fileSystem;
    private final NavigatorPlugin _plugin;
    private NavigatorGuiImpl _proxy;
    private final LinkedList<NavigatorExtension> _tempExtensions;
    private Workbench _workbench;

    public NavigatorGuiProxy(FilesystemController fileSystem, Workbench workbench, NavigatorPlugin plugin) {
        this._fileSystem = fileSystem;
        this._plugin = plugin;
        this._workbench = workbench;
        this._tempExtensions = new LinkedList();
    }

    @Override
    public void openWindow() {
        this.ensureProxyInitialized().openWindow();
    }

    @Override
    public void closeWindow() {
        if (this._proxy != null) {
            this.ensureProxyInitialized().closeWindow();
            this.ensureProxyFreed();
        }
    }

    @Override
    public List<NavigatorExtension> getExtensions() {
        if (this._proxy == null) {
            return this._tempExtensions;
        }
        return this._proxy.getExtensions();
    }

    @Override
    public void addExtension(NavigatorExtension extension) {
        if (this._proxy == null) {
            this._tempExtensions.add(extension);
            return;
        }
        this._proxy.addExtension(extension);
    }

    @Override
    public boolean removeExtension(NavigatorExtension extension) {
        if (this._proxy == null) {
            return this._tempExtensions.remove(extension);
        }
        return this._proxy.removeExtension(extension);
    }

    @Override
    public DefaultFileTreeCellRenderer getTreeCellRenderer() {
        return this.ensureProxyInitialized().getTreeCellRenderer();
    }

    @Override
    public JTree getTree() {
        return this.ensureProxyInitialized().getTree();
    }

    @Override
    public DefaultMutableTreeNode getRootNode() {
        return this.ensureProxyInitialized().getRootNode();
    }

    @Override
    public void collapseAll() {
        this.ensureProxyInitialized().collapseAll();
    }

    @Override
    public void expand() {
        this.ensureProxyInitialized().expand();
    }

    @Override
    public void removeSelectedNodes() {
        this.ensureProxyInitialized().removeSelectedNodes();
    }

    @Override
    public List<TreeElement> getSelectedElements() {
        return this.ensureProxyInitialized().getSelectedElements();
    }

    private NavigatorGuiImpl ensureProxyInitialized() {
        if (this._proxy != null) {
            return this._proxy;
        }
        this._proxy = new NavigatorGuiImpl(this._fileSystem, this._workbench, this._plugin);
        for (NavigatorExtension extension : this._tempExtensions) {
            this._proxy.addExtension(extension);
        }
        this._tempExtensions.clear();
        return this._proxy;
    }

    private void ensureProxyFreed() {
        if (this._proxy == null) {
            return;
        }
        for (NavigatorExtension extension : this._proxy.getExtensions()) {
            this._tempExtensions.add(extension);
        }
        this._proxy = null;
    }
}

