/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelListener;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.themes.font.ButtonFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class MiniButtonContent
extends JComponent {
    private BasicButtonModel model;
    private OrientedLabel label;
    private Color labelOriginalColor;
    private ActionColor textColor;
    private ActionColor textColorDisabled;
    private boolean foregroundColorSet = false;
    private PropertyValue<Dimension> minimumIconSize = new PropertyValue<Dimension>(IconManager.MINIMUM_ICON_SIZE){

        @Override
        protected void valueChanged(Dimension oldValue, Dimension newValue) {
            MiniButtonContent.this.revalidate();
        }
    };
    private BasicButtonModelListener listener = new BasicButtonModelAdapter(){

        public void orientationChanged(BasicButtonModel model, DockTitle.Orientation old, DockTitle.Orientation orientation) {
            MiniButtonContent.this.label.setHorizontal(orientation.isHorizontal());
        }

        public void enabledStateChanged(BasicButtonModel model, boolean enabled) {
            MiniButtonContent.this.updateLabelEnabled();
        }

        public void textChanged(BasicButtonModel model, String oldText, String text) {
            MiniButtonContent.this.label.setText(text);
        }

        public void bound(BasicButtonModel model, DockController controller) {
            MiniButtonContent.this.minimumIconSize.setProperties(controller);
            MiniButtonContent.this.font.connect(controller);
            if (MiniButtonContent.this.textColor != null) {
                MiniButtonContent.this.textColor.connect(controller);
                MiniButtonContent.this.textColorDisabled.connect(controller);
            }
        }

        public void unbound(BasicButtonModel model, DockController controller) {
            MiniButtonContent.this.minimumIconSize.setProperties((DockController)null);
            MiniButtonContent.this.font.connect(null);
            if (MiniButtonContent.this.textColor != null) {
                MiniButtonContent.this.textColor.connect(null);
                MiniButtonContent.this.textColorDisabled.connect(null);
            }
        }
    };
    private ButtonFont font;

    public MiniButtonContent() {
        this.label = new OrientedLabel(){

            public boolean contains(int x, int y) {
                return false;
            }

            public void updateUI() {
                Color current = this.getForeground();
                if (MiniButtonContent.this.labelOriginalColor != null) {
                    this.setForeground(MiniButtonContent.this.labelOriginalColor);
                }
                super.updateUI();
                MiniButtonContent.this.labelOriginalColor = this.getForeground();
                if (MiniButtonContent.this.labelOriginalColor != null) {
                    this.setForeground(current);
                }
            }
        };
        this.labelOriginalColor = this.label.getForeground();
        this.setFocusable(false);
        this.label.setFocusable(false);
        this.setLayout(null);
        this.setOpaque(false);
        this.add(this.label);
        this.label.setIconOffset(0);
        this.label.setIconTextDistance(2);
        this.label.setPaintDisabledIcon(false);
    }

    public void setForegroundColorId(String id, String disabledId) {
        if (this.textColor == null) {
            this.textColor = new ActionColor(id, this.model.getDockable(), this.model.getAction(), null){

                protected void changed(Color oldValue, Color newValue) {
                    if (oldValue != newValue && MiniButtonContent.this.model.isEnabled()) {
                        MiniButtonContent.this.setLabelForeground(newValue);
                    }
                }
            };
            this.textColorDisabled = new ActionColor(disabledId, this.model.getDockable(), this.model.getAction(), null){

                protected void changed(Color oldValue, Color newValue) {
                    if (oldValue != newValue && !MiniButtonContent.this.model.isEnabled()) {
                        MiniButtonContent.this.setLabelForeground(newValue);
                    }
                }
            };
        } else {
            this.textColor.setId(id);
        }
    }

    public void setLabelForeground(Color color) {
        if (color == null) {
            this.label.setForeground(this.labelOriginalColor);
        } else {
            this.label.setForeground(color);
        }
        boolean bl = this.foregroundColorSet = color != null;
        if (this.foregroundColorSet) {
            this.label.setEnabled(true);
        } else {
            this.label.setEnabled(this.model.isEnabled());
        }
    }

    public void updateLabelEnabled() {
        boolean enabled = this.model.isEnabled();
        if (this.textColor != null) {
            if (enabled) {
                this.setLabelForeground(this.textColor.color());
            } else {
                this.setLabelForeground(this.textColorDisabled.color());
            }
        } else if (!this.foregroundColorSet) {
            this.label.setEnabled(enabled);
        } else {
            this.label.setEnabled(true);
        }
    }

    public Dimension getPreferredSize() {
        return this.label.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.label.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return this.label.getMaximumSize();
    }

    public void doLayout() {
        Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Dimension preferred = this.label.getPreferredSize();
        int dw = Math.max(0, bounds.width - preferred.width);
        int dh = Math.max(0, bounds.height - preferred.height);
        bounds.x += dw / 2;
        bounds.y += dh / 2;
        bounds.width -= dw;
        bounds.height -= dh;
        this.label.setBounds(bounds);
    }

    public boolean contains(int x, int y) {
        return false;
    }

    public void setModel(BasicButtonModel model) {
        if (this.model != null) {
            throw new IllegalStateException("the model can be set only once");
        }
        if (this.model != null) {
            this.model.removeListener(this.listener);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addListener(this.listener);
        }
        if (this.textColor != null) {
            this.textColor.connect(null);
            this.textColorDisabled.connect(null);
            String id = this.textColor.getId();
            String disabledId = this.textColorDisabled.getId();
            this.textColor = null;
            this.textColorDisabled = null;
            this.setForeground(null);
            this.setForegroundColorId(id, disabledId);
        }
        this.updateFont();
        this.updateContent();
    }

    private void updateFont() {
        if (this.font != null) {
            this.font.connect(null);
        }
        this.font = null;
        if (this.model != null) {
            this.font = new ButtonFont("button", this.model.getDockable(), this.model.getAction(), null){

                protected void changed(FontModifier oldValue, FontModifier newValue) {
                    MiniButtonContent.this.label.setFontModifier(newValue);
                }
            };
        }
    }

    protected void updateContent() {
        if (this.model == null) {
            this.label.setIcon(null);
            this.label.setText(null);
            this.label.setHorizontal(true);
            this.label.setEnabled(true);
        } else {
            this.label.setIcon(new ForwardIcon());
            this.label.setText(this.model.getText());
            this.label.setHorizontal(this.model.getOrientation().isHorizontal());
            this.label.setEnabled(this.model.isEnabled());
        }
    }

    protected Dimension getMinimumIconSize() {
        return this.minimumIconSize.getValue();
    }

    private class ForwardIcon
    implements Icon {
        private ForwardIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = MiniButtonContent.this.model.getPaintIcon();
            if (icon != null) {
                Dimension min = MiniButtonContent.this.getMinimumIconSize();
                Dimension max = MiniButtonContent.this.model.getMaxIconSize();
                int dx = (Math.max(max.width, min.width) - icon.getIconWidth()) / 2;
                int dy = (Math.max(max.height, min.height) - icon.getIconHeight()) / 2;
                icon.paintIcon(c, g, x + dx, y + dy);
            }
        }

        public int getIconWidth() {
            Dimension min = MiniButtonContent.this.getMinimumIconSize();
            return Math.max(min.width, ((MiniButtonContent)MiniButtonContent.this).model.getMaxIconSize().width);
        }

        public int getIconHeight() {
            Dimension min = MiniButtonContent.this.getMinimumIconSize();
            return Math.max(min.height, ((MiniButtonContent)MiniButtonContent.this).model.getMaxIconSize().height);
        }
    }
}

