/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.magnet;

import bibliothek.gui.dock.station.screen.magnet.MagnetRequest;

public class StickMagnetGraphConstraint {
    private int[] deltas = new int[4];
    private boolean[] hard = new boolean[4];
    private boolean[] direct = new boolean[4];

    public StickMagnetGraphConstraint() {
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < 4; ++i) {
            this.deltas[i] = Integer.MIN_VALUE;
            this.hard[i] = false;
            this.direct[i] = false;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("[");
        boolean first = true;
        for (MagnetRequest.Side side : MagnetRequest.Side.values()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(side.name().toLowerCase()).append(":");
            if (this.isSet(side)) {
                builder.append(" ");
                builder.append(this.get(side));
            }
            if (!this.isHard(side)) continue;
            builder.append(" (hard)");
        }
        builder.append("]");
        return builder.toString();
    }

    public void set(MagnetRequest.Side side, int delta) {
        this.deltas[side.ordinal()] = delta;
    }

    public void set(MagnetRequest.Side side, int delta, boolean direct, boolean hard) {
        this.set(side, delta);
        this.setHard(side, hard);
        this.setDirect(side, direct);
    }

    public boolean isSet(MagnetRequest.Side side) {
        return this.deltas[side.ordinal()] != Integer.MIN_VALUE;
    }

    public int get(MagnetRequest.Side side) {
        if (!this.isSet(side)) {
            throw new IllegalArgumentException("side " + (Object)((Object)side) + " is not set");
        }
        return this.deltas[side.ordinal()];
    }

    public void setHard(MagnetRequest.Side side, boolean hard) {
        this.hard[side.ordinal()] = hard;
    }

    public boolean isHard(MagnetRequest.Side side) {
        return this.hard[side.ordinal()];
    }

    public void setDirect(MagnetRequest.Side side, boolean direct) {
        this.direct[side.ordinal()] = direct;
    }

    public boolean isDirect(MagnetRequest.Side side) {
        return this.direct[side.ordinal()];
    }
}

