/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.BubbleStackDockComponent;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentListener;
import bibliothek.gui.dock.station.stack.action.DockActionDistributor;
import bibliothek.gui.dock.station.stack.action.DockActionDistributorSource;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabComponentLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneTabBackgroundComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.render.DockRenderingHints;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class BubbleTab
extends ConfiguredBackgroundPanel
implements CombinedTab,
StackDockComponentListener,
Runnable,
DockableFocusListener {
    private OrientedLabel label = new OrientedLabel();
    private ButtonPanel actions = new ButtonPanel(false);
    private DockActionDistributorSource actionsSource;
    private TabComponentLayoutManager layoutManager;
    private BubbleColorAnimation animation;
    private boolean mouse = false;
    private boolean focused = false;
    private Dockable dockable;
    private DockController controller;
    private BubbleStackDockComponent parent;
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();
    private int zOrder;
    private int arc = 6;
    private int borderSize = 3;
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;
    private BubbleTabColor topMouse;
    private BubbleTabColor bottomMouse;
    private BubbleTabColor borderMouse;
    private BubbleTabColor textMouse;
    private BubbleTabColor top;
    private BubbleTabColor bottom;
    private BubbleTabColor border;
    private BubbleTabColor text;
    private BubbleTabColor topSelectedMouse;
    private BubbleTabColor bottomSelectedMouse;
    private BubbleTabColor borderSelectedMouse;
    private BubbleTabColor textSelectedMouse;
    private BubbleTabColor topSelected;
    private BubbleTabColor bottomSelected;
    private BubbleTabColor borderSelected;
    private BubbleTabColor textSelected;
    private BubbleTabColor topFocusedMouse;
    private BubbleTabColor bottomFocusedMouse;
    private BubbleTabColor borderFocusedMouse;
    private BubbleTabColor textFocusedMouse;
    private BubbleTabColor topFocused;
    private BubbleTabColor bottomFocused;
    private BubbleTabColor borderFocused;
    private BubbleTabColor textFocused;
    private BubbleTabColor topDisabled;
    private BubbleTabColor bottomDisabled;
    private BubbleTabColor borderDisabled;
    private BubbleTabColor textDisabled;
    private BubbleTabColor[] colors;
    private BubbleTabFont fontFocused;
    private BubbleTabFont fontSelected;
    private BubbleTabFont fontUnselected;
    private Background background = new Background();
    private static final int STATE_SELECTED = 1;
    private static final int STATE_FOCUSED = 3;
    private static final int STATE_MOUSE = 4;
    private static final int STATE_DISABLED = 8;
    private int state = 0;

    public BubbleTab(BubbleStackDockComponent parent, Dockable dockable) {
        super(Transparency.DEFAULT);
        this.dockable = dockable;
        this.parent = parent;
        this.label.setHorizontal(this.orientation.isHorizontal());
        this.label.setBackground(this.background);
        this.setBackground(this.background);
        this.animation = new BubbleColorAnimation();
        this.animation.addTask(this);
        this.topMouse = new BubbleTabColor(4, "stack.tab.background.top.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomMouse = new BubbleTabColor(4, "stack.tab.background.bottom.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderMouse = new BubbleTabColor(4, "stack.tab.border.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textMouse = new BubbleTabColor(4, "stack.tab.foreground.mouse", "text", this.animation, dockable, Color.BLACK);
        this.top = new BubbleTabColor(0, "stack.tab.background.top", "top", this.animation, dockable, Color.RED.brighter());
        this.bottom = new BubbleTabColor(0, "stack.tab.background.bottom", "bottom", this.animation, dockable, Color.RED.darker());
        this.border = new BubbleTabColor(0, "stack.tab.border", "border", this.animation, dockable, Color.RED.darker().darker());
        this.text = new BubbleTabColor(0, "stack.tab.foreground", "text", this.animation, dockable, Color.BLACK);
        this.topSelectedMouse = new BubbleTabColor(5, "stack.tab.background.top.selected.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomSelectedMouse = new BubbleTabColor(5, "stack.tab.background.bottom.selected.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderSelectedMouse = new BubbleTabColor(5, "stack.tab.border.selected.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textSelectedMouse = new BubbleTabColor(5, "stack.tab.foreground.selected.mouse", "text", this.animation, dockable, Color.BLACK);
        this.topSelected = new BubbleTabColor(1, "stack.tab.background.top.selected", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomSelected = new BubbleTabColor(1, "stack.tab.background.bottom.selected", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderSelected = new BubbleTabColor(1, "stack.tab.border.selected", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textSelected = new BubbleTabColor(1, "stack.tab.foreground.selected", "text", this.animation, dockable, Color.BLACK);
        this.topFocusedMouse = new BubbleTabColor(7, "stack.tab.background.top.focused.mouse", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomFocusedMouse = new BubbleTabColor(7, "stack.tab.background.bottom.focused.mouse", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderFocusedMouse = new BubbleTabColor(7, "stack.tab.border.focused.mouse", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textFocusedMouse = new BubbleTabColor(7, "stack.tab.foreground.focused.mouse", "text", this.animation, dockable, Color.BLACK);
        this.topFocused = new BubbleTabColor(3, "stack.tab.background.top.focused", "top", this.animation, dockable, Color.RED.brighter());
        this.bottomFocused = new BubbleTabColor(3, "stack.tab.background.bottom.focused", "bottom", this.animation, dockable, Color.RED.darker());
        this.borderFocused = new BubbleTabColor(3, "stack.tab.border.focused", "border", this.animation, dockable, Color.RED.darker().darker());
        this.textFocused = new BubbleTabColor(3, "stack.tab.foreground.focused", "text", this.animation, dockable, Color.BLACK);
        this.topDisabled = new BubbleTabColor(8, "stack.tab.background.top.disabled", "top", this.animation, dockable, Color.LIGHT_GRAY.brighter());
        this.bottomDisabled = new BubbleTabColor(8, "stack.tab.background.bottom.disabled", "bottom", this.animation, dockable, Color.LIGHT_GRAY.darker());
        this.borderDisabled = new BubbleTabColor(8, "stack.tab.border.disabled", "border", this.animation, dockable, Color.LIGHT_GRAY.darker().darker());
        this.textDisabled = new BubbleTabColor(8, "stack.tab.foreground.disabled", "text", this.animation, dockable, Color.BLACK);
        this.colors = new BubbleTabColor[]{this.top, this.bottom, this.border, this.text, this.topMouse, this.bottomMouse, this.borderMouse, this.textMouse, this.topDisabled, this.bottomDisabled, this.borderDisabled, this.textDisabled, this.topSelected, this.bottomSelected, this.borderSelected, this.textSelected, this.topSelectedMouse, this.bottomSelectedMouse, this.borderSelectedMouse, this.textSelectedMouse, this.topFocused, this.bottomFocused, this.borderFocused, this.textFocused, this.topFocusedMouse, this.bottomFocusedMouse, this.borderFocusedMouse, this.textFocusedMouse};
        this.fontFocused = new BubbleTabFont("tab.focused", dockable);
        this.fontSelected = new BubbleTabFont("tab.selected", dockable);
        this.fontUnselected = new BubbleTabFont("tab.unselected", dockable);
        this.setController(parent.getController());
        this.checkAnimation();
        this.setOpaque(false);
        this.add(this.label);
        this.add(this.actions);
        this.layoutManager = new TabComponentLayoutManager(this.label, this.actions, parent.getConfiguration(dockable));
        this.layoutManager.setFreeSpaceToSideBorder(this.borderSize + this.borderSize);
        this.layoutManager.setFreeSpaceToParallelBorder(this.borderSize);
        this.layoutManager.setFreeSpaceBetweenLabelAndActions(this.borderSize);
        this.layoutManager.setFreeSpaceToOpenSide(this.arc);
        this.setLayout(this.layoutManager);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                BubbleTab.this.parent.setSelectedDockable(BubbleTab.this.dockable);
            }

            public void mouseEntered(MouseEvent e) {
                BubbleTab.this.mouse = true;
                BubbleTab.this.checkAnimation();
            }

            public void mouseExited(MouseEvent e) {
                BubbleTab.this.mouse = false;
                BubbleTab.this.checkAnimation();
            }
        };
        this.addMouseListener(listener);
        this.label.addMouseListener(listener);
    }

    public void setConfiguration(TabConfiguration configuration) {
        this.layoutManager.setConfiguration(configuration);
    }

    public TabPane getTabParent() {
        return this.parent;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    public void setTooltip(String tooltip) {
        this.setToolTipText(tooltip);
        this.label.setToolTipText(tooltip);
    }

    public void setPaneVisible(boolean visible) {
        this.parent.getTabHandler().setVisible(this, visible);
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            this.label.setEnabled(enabled);
            if (enabled) {
                for (MouseInputListener listener : this.mouseInputListeners) {
                    this.doRemoveMouseInputListener(listener);
                }
            } else {
                for (MouseInputListener listener : this.mouseInputListeners) {
                    this.doAddMouseInputListener(listener);
                }
            }
            this.checkAnimation();
        }
    }

    public boolean isPaneVisible() {
        return this.parent.getTabHandler().isVisible(this);
    }

    public void setOrientation(TabPlacement orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.layoutManager.setOrientation(orientation);
            this.revalidate();
            this.repaint();
        }
    }

    public int getState() {
        return this.state;
    }

    public void setController(DockController controller) {
        if (this.controller != null) {
            this.controller.removeDockableFocusListener(this);
        }
        for (BubbleTabColor color : this.colors) {
            color.connect(controller);
        }
        this.fontFocused.connect(controller);
        this.fontSelected.connect(controller);
        this.fontUnselected.connect(controller);
        this.background.setController(controller);
        this.actions.setController(controller);
        this.controller = controller;
        if (controller == null) {
            if (this.actionsSource != null) {
                this.actions.set(null);
                this.actionsSource.setDockable(null);
                this.actionsSource = null;
            }
        } else {
            controller.addDockableFocusListener(this);
            boolean bl = this.focused = controller.getFocusedDockable() == this.dockable;
            if (this.actionsSource == null) {
                this.actionsSource = new DockActionDistributorSource(DockActionDistributor.Target.TAB, BubbleTheme.ACTION_DISTRIBUTOR);
                this.actionsSource.setDockable(this.getDockable());
                this.actions.set(this.getDockable(), this.actionsSource);
            }
        }
        this.checkAnimation();
        this.animation.kick();
    }

    public void setZOrder(int order) {
        this.zOrder = order;
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public Insets getOverlap(TabPaneComponent other) {
        return new Insets(0, 0, 0, 0);
    }

    public void dockableFocused(DockableFocusEvent event) {
        boolean old = this.focused;
        boolean bl = this.focused = this.dockable == event.getNewFocusOwner();
        if (old != this.focused) {
            this.checkAnimation();
        }
    }

    public void run() {
        this.label.setForeground(this.animation.getColor("text"));
        this.repaint();
    }

    public Dimension getPreferredSize(Tab[] tabs) {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize(Tab[] tabs) {
        return this.getMinimumSize();
    }

    protected void setupRenderingHints(Graphics g) {
        if (this.controller != null) {
            DockRenderingHints renderingHints = this.controller.getProperties().get(DockRenderingHints.RENDERING_HINTS);
            renderingHints.setupGraphics(g);
        }
    }

    public void paintBackground(Graphics g) {
        if (this.getTransparency() != Transparency.TRANSPARENT) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color bottom = this.animation.getColor("bottom");
            Color top = this.animation.getColor("top");
            Color border = this.animation.getColor("border");
            int w = this.getWidth();
            int h = this.getHeight();
            g2.setColor(border);
            switch (this.orientation) {
                case TOP_OF_DOCKABLE: {
                    g2.fillRoundRect(0, 0, w, h + this.arc, 2 * this.arc, 2 * this.arc);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: {
                    g2.fillRoundRect(0, -this.arc, w, h + this.arc, 2 * this.arc, 2 * this.arc);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    g2.fillRoundRect(0, 0, w + this.arc, h, 2 * this.arc, 2 * this.arc);
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    g2.fillRoundRect(-this.arc, 0, w + this.arc, h, 2 * this.arc, 2 * this.arc);
                }
            }
            if (this.orientation.isHorizontal()) {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, top, 0.0f, h - this.borderSize, bottom));
            } else {
                g2.setPaint(new GradientPaint(0.0f, 0.0f, top, w - this.borderSize, 0.0f, bottom));
            }
            switch (this.orientation) {
                case TOP_OF_DOCKABLE: {
                    g2.fillRoundRect(this.borderSize, this.borderSize, w - 2 * this.borderSize, h + this.arc - this.borderSize, 2 * this.arc, 2 * this.arc);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: {
                    g2.fillRoundRect(this.borderSize, -this.arc, w - 2 * this.borderSize, h + this.arc - this.borderSize, 2 * this.arc, 2 * this.arc);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    g2.fillRoundRect(this.borderSize, this.borderSize, w + this.arc - this.borderSize, h - 2 * this.borderSize, 2 * this.arc, 2 * this.arc);
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    g2.fillRoundRect(-this.arc, this.borderSize, w + this.arc - this.borderSize, h - 2 * this.borderSize, 2 * this.arc, 2 * this.arc);
                }
            }
            g2.dispose();
        }
    }

    public void paintForeground(Graphics g) {
        super.paintChildren(g);
    }

    public void paintOverlay(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.orientation.isHorizontal()) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), 0.0f, h / 2, Color.WHITE));
        } else {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(150, 150, 150), w / 2, 0.0f, Color.WHITE));
        }
        g2.setComposite(AlphaComposite.getInstance(10, 0.4f));
        switch (this.orientation) {
            case TOP_OF_DOCKABLE: {
                g2.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, w, h + this.arc, 2 * this.arc, 2 * this.arc));
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                g2.setClip(new RoundRectangle2D.Float(0.0f, -this.arc, w, h + this.arc, 2 * this.arc, 2 * this.arc));
                break;
            }
            case LEFT_OF_DOCKABLE: {
                g2.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, w + this.arc, h, 2 * this.arc, 2 * this.arc));
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                g2.setClip(new RoundRectangle2D.Float(-this.arc, 0.0f, w + this.arc, h, 2 * this.arc, 2 * this.arc));
            }
        }
        if (this.orientation.isHorizontal()) {
            g2.fillRect(0, 0, w, h / 2);
        } else {
            g2.fillRect(0, 0, w / 2, h);
        }
        g2.dispose();
    }

    public JComponent getComponent() {
        return this;
    }

    public DockElement getElement() {
        return this.dockable;
    }

    public boolean isUsedAsTitle() {
        return false;
    }

    public boolean shouldFocus() {
        return true;
    }

    public boolean shouldTransfersFocus() {
        return true;
    }

    public void addMouseInputListener(MouseInputListener listener) {
        this.mouseInputListeners.add(listener);
        if (this.isEnabled()) {
            this.doAddMouseInputListener(listener);
        }
    }

    private void doAddMouseInputListener(MouseInputListener listener) {
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.label.addMouseListener(listener);
        this.label.addMouseMotionListener(listener);
    }

    public void removeMouseInputListener(MouseInputListener listener) {
        this.mouseInputListeners.remove(listener);
        if (this.isEnabled()) {
            this.doRemoveMouseInputListener(listener);
        }
    }

    private void doRemoveMouseInputListener(MouseInputListener listener) {
        this.removeMouseListener(listener);
        this.removeMouseMotionListener(listener);
        this.label.removeMouseListener(listener);
        this.label.removeMouseMotionListener(listener);
    }

    public void selectionChanged(StackDockComponent stack) {
        this.checkAnimation();
    }

    public void tabChanged(StackDockComponent stack, Dockable dockable) {
    }

    private void checkAnimation() {
        this.state = 0;
        if (!this.isEnabled()) {
            this.state = 8;
        } else {
            if (this.parent.getSelectedDockable() == this.dockable) {
                this.state |= 1;
            }
            if (this.mouse) {
                this.state |= 4;
            }
            if (this.focused) {
                this.state |= 3;
            }
        }
        for (BubbleTabColor color : this.colors) {
            color.transmit();
        }
        this.updateFonts();
    }

    public void updateFonts() {
        if (!this.isEnabled()) {
            this.label.setFontModifier((FontModifier)this.fontUnselected.value());
        } else if (this.focused) {
            this.label.setFontModifier((FontModifier)this.fontFocused.value());
        } else if (this.parent.getSelectedDockable() == this.dockable) {
            this.label.setFontModifier((FontModifier)this.fontSelected.value());
        } else {
            this.label.setFontModifier((FontModifier)this.fontUnselected.value());
        }
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void stopAnimation() {
        this.animation.stop();
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneTabBackgroundComponent {
        public Background() {
            super(TabPaneTabBackgroundComponent.KIND, "dock.background.tabPane.child.tab");
        }

        public Tab getTab() {
            return BubbleTab.this;
        }

        public TabPaneComponent getChild() {
            return BubbleTab.this;
        }

        public TabPane getPane() {
            return BubbleTab.this.getTabParent();
        }

        public Component getComponent() {
            return BubbleTab.this;
        }
    }

    protected class BubbleTabFont
    extends TabFont {
        public BubbleTabFont(String id, Dockable dockable) {
            super(id, BubbleTab.this.parent.getStation(), dockable);
        }

        protected void changed(FontModifier oldValue, FontModifier newValue) {
            BubbleTab.this.updateFonts();
        }
    }

    protected class BubbleTabColor
    extends TabColor {
        private int state;
        private String animationId;
        private BubbleColorAnimation animation;

        public BubbleTabColor(int state, String id, String animationId, BubbleColorAnimation animation, Dockable dockable, Color backup) {
            super(id, BubbleTab.this.parent.getStation(), dockable, backup);
            this.state = state;
            this.animationId = animationId;
            this.animation = animation;
        }

        public void transmit() {
            if (BubbleTab.this.getState() == this.state) {
                this.animation.putColor(this.animationId, (Color)this.value());
            }
        }

        protected void changed(Color oldColor, Color newColor) {
            if (BubbleTab.this.getState() == this.state) {
                this.animation.putColor(this.animationId, newColor);
            }
        }
    }
}

