/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import de.renew.refactoring.wizard.WizardButtons;
import de.renew.refactoring.wizard.WizardController;
import de.renew.refactoring.wizard.WizardListener;
import de.renew.refactoring.wizard.WizardPage;
import de.renew.refactoring.wizard.WizardPageStack;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard
extends WindowAdapter
implements ActionListener,
WizardButtons {
    private static final String PREVIOUS_BUTTON_ACTION_COMMAND = "PREVIOUS";
    private static final String NEXT_BUTTON_ACTION_COMMAND = "NEXT";
    private static final String CANCEL_BUTTON_ACTION_COMMAND = "CANCEL";
    private JDialog _dialog;
    private JPanel _pagePanel;
    private WizardPageStack _pages = new WizardPageStack();
    private WizardController _controller;
    private Set<WizardListener> _listeners = new HashSet<WizardListener>();
    private JButton _previousButton;
    private JButton _nextButton;
    private JButton _cancelButton;
    private boolean _nextButtonFinish = false;

    public Wizard(WizardController controller) {
        this._controller = controller;
        this._controller.setWizardButtons(this);
        this.initComponents(this._controller.getTitle());
        this.start();
    }

    private void start() {
        this.showNextPage();
        this._dialog.setVisible(true);
    }

    public boolean addListener(WizardListener listener) {
        return this._listeners.add(listener);
    }

    public boolean removeListener(WizardListener listener) {
        return this._listeners.remove(listener);
    }

    private void initComponents(String title) {
        this._dialog = new JDialog();
        this._dialog.setTitle(title);
        this._dialog.setSize(500, 500);
        this._dialog.setMinimumSize(new Dimension(300, 300));
        this._dialog.getContentPane().setLayout(new BorderLayout());
        this._dialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        Box buttonBox = new Box(0);
        this._pagePanel = new JPanel();
        this._pagePanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this._pagePanel.setLayout(new CardLayout());
        this._previousButton = new JButton("Back");
        this._nextButton = new JButton("Next");
        this._cancelButton = new JButton("Cancel");
        this._previousButton.setActionCommand(PREVIOUS_BUTTON_ACTION_COMMAND);
        this._nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this._cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this._previousButton.addActionListener(this);
        this._nextButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)new JSeparator(), "North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this._previousButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this._nextButton);
        buttonBox.add(Box.createHorizontalStrut(30));
        buttonBox.add(this._cancelButton);
        buttonPanel.add((Component)buttonBox, "East");
        this._dialog.getContentPane().add((Component)buttonPanel, "South");
        this._dialog.getContentPane().add((Component)this._pagePanel, "Center");
        this._dialog.getRootPane().setDefaultButton(this._nextButton);
    }

    private void showNextPage() {
        this.save();
        WizardPage next = this._controller.getNextPage();
        if (next == null) {
            return;
        }
        next.didLoad();
        this._pages.push(next);
        this._pagePanel.add((Component)next.getPanel(), next.getId());
        this.configureForPage(next);
    }

    private void save() {
        WizardPage current = this.getCurrentPage();
        if (current != null) {
            current.saveState();
            current.willDisappear();
        }
    }

    private void showPreviousPage() {
        this.popCurrentPage();
        this.configureForPage(this.getCurrentPage());
    }

    private void popCurrentPage() {
        WizardPage current = this.getCurrentPage();
        current.resetState();
        current.willDisappear();
        this._pages.pop();
        this._pagePanel.remove(current.getPanel());
    }

    private void cancel() {
        while (this._pages.size() > 0) {
            this.popCurrentPage();
        }
        this.dispose();
    }

    private void dispose() {
        this.informListeners();
        this._dialog.dispose();
    }

    private void configureForPage(WizardPage page) {
        this._pagePanel.revalidate();
        ((CardLayout)this._pagePanel.getLayout()).show(this._pagePanel, page.getId());
        this.internalSetPreviousButtonEnabled(this._pages.size() > 1);
        this.setNextButtonTitleToFinish(page.isLastPage());
        String nextButtonTitle = page.nextButtonTitle();
        if (nextButtonTitle != null) {
            this.setNextButtonTitle(nextButtonTitle);
        }
        page.internalDidAppear();
    }

    private WizardPage getCurrentPage() {
        return this._pages.peek();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cancel();
    }

    private void informListeners() {
        for (WizardListener listener : this._listeners) {
            listener.wizardFinished();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(PREVIOUS_BUTTON_ACTION_COMMAND)) {
            this.backButtonPressed();
        } else if (e.getActionCommand().equals(NEXT_BUTTON_ACTION_COMMAND)) {
            if (this._nextButtonFinish) {
                this.finishButtonPressed();
            } else {
                this.nextButtonPressed();
            }
        } else if (e.getActionCommand().equals(CANCEL_BUTTON_ACTION_COMMAND)) {
            this.cancelButtonPressed();
        }
    }

    private void backButtonPressed() {
        this.showPreviousPage();
    }

    private void nextButtonPressed() {
        this.showNextPage();
    }

    private void finishButtonPressed() {
        this.save();
        this.dispose();
    }

    private void cancelButtonPressed() {
        this.cancel();
    }

    private void internalSetPreviousButtonEnabled(boolean enabled) {
        this._previousButton.setEnabled(enabled);
    }

    @Override
    public void setPreviousButtonEnabled(boolean enabled) {
        if (enabled) {
            return;
        }
        this._previousButton.setEnabled(false);
    }

    @Override
    public void setNextButtonEnabled(boolean enabled) {
        this._nextButton.setEnabled(enabled);
    }

    @Override
    public void focusNextButton() {
        this._nextButton.requestFocusInWindow();
    }

    private void setNextButtonTitleToFinish(boolean finish) {
        this._nextButtonFinish = finish;
        this._nextButton.setText(finish ? "Finish" : "Next");
    }

    private void setNextButtonTitle(String title) {
        this._nextButton.setText(title);
    }
}

