/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import de.renew.refactoring.match.TextFigureMatch;
import de.renew.refactoring.wizard.ShowTextFigureButtonCell;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;

public class SelectMatchesTable<T extends TextFigureMatch>
extends JTable {
    private static final long serialVersionUID = 5728970344351229491L;
    private static final Logger LOGGER = Logger.getLogger(SelectMatchesTable.class);
    private final Class<T> _type;
    private final Object[][] _rowData;
    private final String[] _columnNames;
    private final int[] _uneditableRows;
    private final int _checkboxColumn = 0;
    private final int _textFigureMatchColumn;

    public SelectMatchesTable(Class<T> type, Object[][] rowData, String[] columnNames, int[] uneditableRows) {
        this._type = type;
        this._rowData = rowData;
        this._columnNames = columnNames;
        this._uneditableRows = uneditableRows != null ? uneditableRows : new int[]{};
        this._textFigureMatchColumn = this._columnNames.length - 1;
        this.configureTable();
    }

    private boolean isRowEditable(int row) {
        for (int i = 0; i < this._uneditableRows.length; ++i) {
            if (this._uneditableRows[i] != row) continue;
            return false;
        }
        return true;
    }

    private void configureTable() {
        this.setModel(new AbstractTableModel(){
            private static final long serialVersionUID = 5656622377240990426L;

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return SelectMatchesTable.this._rowData[rowIndex][columnIndex];
            }

            @Override
            public int getRowCount() {
                return SelectMatchesTable.this._rowData.length;
            }

            @Override
            public int getColumnCount() {
                return SelectMatchesTable.this._columnNames.length;
            }

            @Override
            public String getColumnName(int column) {
                return SelectMatchesTable.this._columnNames[column];
            }

            public Class<? extends Object> getColumnClass(int c) {
                return SelectMatchesTable.this._rowData.length > 0 ? this.getValueAt(0, c).getClass() : Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                if (col == SelectMatchesTable.this._textFigureMatchColumn) {
                    return true;
                }
                return SelectMatchesTable.this.isRowEditable(row) && col == 0;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (this.isCellEditable(row, col)) {
                    SelectMatchesTable.this._rowData[row][col] = value;
                    this.fireTableCellUpdated(row, col);
                }
            }
        });
        this.setDefaultEditor(this._type, new ShowTextFigureButtonCell());
        this.setDefaultRenderer(this._type, new ShowTextFigureButtonCell());
        this.getColumnModel().getColumn(0).setMaxWidth(60);
        this.getColumnModel().getColumn(this._textFigureMatchColumn).setMaxWidth(80);
        this.setRowHeight(25);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        c.setEnabled(this.isRowEditable(row) || column != 0);
        return c;
    }

    public List<T> getSelectedItems() {
        ArrayList<TextFigureMatch> selectedItems = new ArrayList<TextFigureMatch>();
        for (Object[] row : this._rowData) {
            if (!((Boolean)row[0]).booleanValue()) continue;
            selectedItems.add((TextFigureMatch)row[this._textFigureMatchColumn]);
        }
        return selectedItems;
    }
}

