/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import de.renew.expression.AggregateExpression;
import de.renew.expression.CallExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.GuardExpression;
import de.renew.expression.InvertibleExpression;
import de.renew.expression.LocalVariable;
import de.renew.expression.TypeCheckingExpression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.java.JavaNetParser;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.net.TransitionInscription;
import de.renew.net.UplinkInscription;
import de.renew.net.inscription.ActionInscription;
import de.renew.net.inscription.ConditionalInscription;
import de.renew.net.inscription.CreationInscription;
import de.renew.net.inscription.DownlinkInscription;
import de.renew.net.inscription.ExpressionInscription;
import de.renew.net.inscription.GuardInscription;
import de.renew.net.inscription.RangeEnumeratorInscription;
import de.renew.net.inscription.SimpleEnumeratorInscription;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.JNPParser;
import de.renew.refactoring.parse.VariableParser;
import de.renew.refactoring.util.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class JNPVariableParser
implements VariableParser {
    private static final Logger LOGGER = Logger.getLogger(JNPVariableParser.class);
    private final String _declaration;
    private final ParsedDeclarationNode _declarationNode;

    public JNPVariableParser(String declaration) {
        this._declaration = declaration;
        ParsedDeclarationNode decl = JNPParser.declarationNode(declaration);
        this._declarationNode = decl != null ? decl : new ParsedDeclarationNode();
    }

    public JNPVariableParser() {
        this("");
    }

    private JavaNetParser netParser(String input) {
        return JNPParser.netParser(input, this._declarationNode);
    }

    @Override
    public boolean isValidVariableName(String name) {
        return JNPParser.isIdentifier(this.netParser(name)) && this._declarationNode.interpreteWellKnownName(name) == null;
    }

    @Override
    public boolean containsVariable(String string) {
        return this.findVariables(string, true).size() > 0;
    }

    @Override
    public List<StringMatch> findVariables(String string) {
        return this.findVariables(string, false);
    }

    private List<StringMatch> findVariables(String string, boolean stopEarly) {
        ArrayList<StringMatch> matches = new ArrayList<StringMatch>();
        for (TransitionInscription i : JNPParser.transitionInscriptions(this.netParser(string))) {
            Collection<VariableExpression> variables = null;
            if (i instanceof ExpressionInscription) {
                ExpressionInscription ei = (ExpressionInscription)i;
                variables = this.findVariableExpressions(ei.getExpression());
            } else if (i instanceof UplinkInscription) {
                UplinkInscription ui = (UplinkInscription)i;
                variables = this.findVariableExpressions(ui.params);
            } else if (i instanceof DownlinkInscription) {
                DownlinkInscription di = (DownlinkInscription)i;
                Collection<VariableExpression> callee = this.findVariableExpressions(di.callee);
                Collection<VariableExpression> params = this.findVariableExpressions(di.params);
                variables = new ArrayList<VariableExpression>(callee);
                variables.addAll(params);
            } else if (i instanceof ActionInscription) {
                ActionInscription ai = (ActionInscription)i;
                variables = this.findVariableExpressions(ai.getExpression());
            } else if (i instanceof CreationInscription) {
                ci = (CreationInscription)i;
                VariableExpression v = new VariableExpression(null, ci.getVariable());
                variables = Collections.singleton(v);
            } else if (i instanceof ConditionalInscription) {
                ci = (ConditionalInscription)i;
                variables = this.findVariableExpressions(ci.getExpression());
            } else if (i instanceof GuardInscription) {
                GuardInscription gi = (GuardInscription)i;
                variables = this.findVariableExpressions(gi.getExpression());
            } else if (i instanceof RangeEnumeratorInscription) {
                RangeEnumeratorInscription rei = (RangeEnumeratorInscription)i;
                LOGGER.debug((Object)("range enumerator inscription not handled yet: " + String.valueOf(rei)));
            } else if (i instanceof SimpleEnumeratorInscription) {
                SimpleEnumeratorInscription sei = (SimpleEnumeratorInscription)i;
                LOGGER.debug((Object)("simple enumerator inscription not handled yet: " + String.valueOf(sei)));
            }
            if (variables == null) continue;
            for (VariableExpression variable : variables) {
                LocalVariable local = variable.getVariable();
                if (local.name.equals("this")) continue;
                matches.add(StringHelper.makeStringMatch(string, local.variableBeginLine, local.variableBeginColumn, local.variableEndLine, local.variableEndColumn));
                if (!stopEarly) continue;
                return matches;
            }
        }
        return matches;
    }

    @Override
    public List<StringMatch> findVariablesInDeclarationNode() {
        ArrayList<StringMatch> result = new ArrayList<StringMatch>();
        for (String name : this._declarationNode.getVariablePositions().keySet()) {
            List position = (List)this._declarationNode.getVariablePositions().get(name);
            result.add(StringHelper.makeStringMatch(this._declaration, (Integer)position.get(0), (Integer)position.get(1), (Integer)position.get(2), (Integer)position.get(3)));
        }
        return result;
    }

    @Override
    public Class<?> findVariableType(String variable) {
        return this._declarationNode.findType(new LocalVariable(variable.trim()));
    }

    private Collection<VariableExpression> findVariableExpressions(Expression expression) {
        LOGGER.debug((Object)("Searching for variable expressions: " + expression.toString()));
        ArrayList<VariableExpression> expressions = new ArrayList<VariableExpression>();
        if (expression instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)expression;
            expressions.add(variableExpression);
        } else if (expression instanceof AggregateExpression) {
            AggregateExpression aggregateExpression = (AggregateExpression)expression;
            for (Expression child : aggregateExpression.getExpressions()) {
                expressions.addAll(this.findVariableExpressions(child));
            }
        } else if (expression instanceof CallExpression) {
            CallExpression callExpression = (CallExpression)expression;
            expressions.addAll(this.findVariableExpressions(callExpression.getArgument()));
        } else if (expression instanceof EqualsExpression) {
            EqualsExpression equalsExpression = (EqualsExpression)expression;
            expressions.addAll(this.findVariableExpressions(equalsExpression.getLeft()));
            expressions.addAll(this.findVariableExpressions(equalsExpression.getRight()));
        } else if (expression instanceof InvertibleExpression) {
            InvertibleExpression invertibleExpression = (InvertibleExpression)expression;
            expressions.addAll(this.findVariableExpressions(invertibleExpression.getArgument()));
        } else if (expression instanceof TypeCheckingExpression) {
            TypeCheckingExpression typeCheckingExpression = (TypeCheckingExpression)expression;
            expressions.addAll(this.findVariableExpressions(typeCheckingExpression.getArgument()));
        } else if (expression instanceof GuardExpression) {
            GuardExpression guardExpression = (GuardExpression)expression;
            expressions.addAll(this.findVariableExpressions((Expression)guardExpression));
        }
        return expressions;
    }
}

