/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.PluginProperties;
import de.renew.plugin.locate.PluginFileFinder;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PluginSubDirFinder
extends PluginFileFinder {
    public static final Logger LOGGER = Logger.getLogger(PluginSubDirFinder.class);

    public PluginSubDirFinder(URL base) {
        super(base);
    }

    @Override
    protected File[] getPluginFiles(File dir) {
        File[] plugins = dir.listFiles(file -> file.isDirectory());
        return plugins;
    }

    @Override
    protected Collection<PluginProperties> getPluginConfigurations(File[] plugins) {
        Vector<PluginProperties> pluginURLv = new Vector<PluginProperties>();
        for (int i = 0; i < plugins.length; ++i) {
            PluginProperties cfg = this.getPluginConfigFromDirectory(plugins[i]);
            if (cfg == null) continue;
            pluginURLv.add(cfg);
        }
        return pluginURLv;
    }

    protected PluginProperties getPluginConfigFromDirectory(File location) {
        if (location.isDirectory()) {
            File[] cfgFiles = location.listFiles((dir, file) -> file.equals("plugin.cfg"));
            File loc = null;
            if (cfgFiles.length > 0) {
                loc = cfgFiles[0];
                if (cfgFiles.length > 1) {
                    LOGGER.warn((Object)("PluginSubDirFinder: " + String.valueOf(location) + " contains more than one plugin.cfg file! using only " + String.valueOf(location)));
                }
            } else {
                LOGGER.debug((Object)("PluginSubDirFinder: no plugin.cfg found in " + String.valueOf(location)));
            }
            if (loc != null) {
                return this.createPluginConfig(loc);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PluginProperties createPluginConfig(File loc) {
        try {
            URL url = loc.toURI().toURL();
            try (FileInputStream stream = new FileInputStream(loc);){
                PluginProperties props;
                PluginProperties pluginProperties = props = new PluginProperties(url, stream);
                return pluginProperties;
            }
            catch (Exception e) {
                LOGGER.error((Object)("PluginSubDirFinder: " + String.valueOf(e)));
                return null;
            }
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)("PluginSubDirFinder: could not create URL from " + String.valueOf(loc) + ": " + String.valueOf(e)));
        }
        return null;
    }

    private static void list(Collection<?> l) {
        for (Object o : l) {
            System.out.println(o);
        }
    }
}

