/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.propertymanagement.ConfigurablePropertyManager;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SetPropertyCommand
implements CLCommand {
    public static final Logger LOGGER = Logger.getLogger(SetPropertyCommand.class);

    @Override
    public void execute(String[] args, PrintStream response) {
        for (int i = 0; i < args.length; ++i) {
            this.setProperty(args[i], response);
        }
    }

    protected void setProperty(String arg, PrintStream response) {
        StringTokenizer tokenizer = new StringTokenizer(arg, "=");
        Object value = null;
        if (!tokenizer.hasMoreTokens()) {
            response.println("Usage: set property=value [property=value ...]");
            response.println("       Don't use spaces around the = sign!");
            return;
        }
        String key = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            response.println("SetPropertyCommand: no argument given for variable " + arg + ", it becomes unset.");
        } else {
            while (tokenizer.hasMoreTokens()) {
                if (value == null) {
                    value = tokenizer.nextToken();
                    continue;
                }
                value = (String)value + "=" + tokenizer.nextToken();
            }
        }
        PluginProperties userProps = PluginProperties.getUserProperties();
        if (value == null) {
            userProps.remove(key);
            for (IPlugin p : PluginManager.getInstance().getPlugins()) {
                PluginProperties props = p.getProperties();
                props.remove(key);
            }
            ConfigurablePropertyManager.getInstance().removeConfigurableProperty(key);
        } else {
            userProps.setProperty(key, (String)value);
            for (IPlugin p : PluginManager.getInstance().getPlugins()) {
                PluginProperties props = p.getProperties();
                props.setProperty(key, (String)value);
            }
            ConfigurablePropertyManager.getInstance().changeProperty(key, (String)value);
        }
    }

    @Override
    public String getDescription() {
        return "sets a system property (syntax key=value)";
    }

    @Override
    public String getArguments() {
        return "propertyNames";
    }
}

