/*
 * Decompiled with CFR 0.152.
 */
package de.renew.faformalism.util;

import de.renew.faformalism.util.FAAutomatonModelEnum;
import de.renew.faformalism.util.SimulationSettingsManager;
import de.renew.faformalism.util.StackDataStructure;
import de.renew.unify.Tuple;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class FAAutomatonSimulationHelper {
    private static final char EPSILON = '\u03b5';
    private static final String DISPLAY_FORMAT = "[(%s, %s), (%s) ] \u2192 [%s, %s]";
    private static final String PDA_RULE_FORMAT = "%c, %c->%c";

    private FAAutomatonSimulationHelper() {
    }

    public static boolean canFire(Tuple currentTuple, String arcInscription) {
        String currentWord = (String)currentTuple.getComponent(0);
        switch (SimulationSettingsManager.getAutomatonModel()) {
            case NFA: 
            case DFA: {
                return FAAutomatonSimulationHelper.canFireNFA(currentWord, arcInscription);
            }
            case BUECHI: {
                return FAAutomatonSimulationHelper.canFireBUECHI(currentWord, arcInscription);
            }
            case PDA: {
                return FAAutomatonSimulationHelper.canFirePDA(currentTuple, arcInscription);
            }
        }
        return false;
    }

    private static boolean canFireNFA(String currentWord, String arcInscription) {
        if (!SimulationSettingsManager.getSimulateWordMode()) {
            return true;
        }
        List<String> allowedByArc = FAAutomatonSimulationHelper.splitNFAArcInscription(arcInscription);
        if (allowedByArc.contains("")) {
            return true;
        }
        List<String> preparedWords = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord);
        for (String word : preparedWords) {
            for (String arcInscr : allowedByArc) {
                if (word.isEmpty() || word.charAt(0) != arcInscr.charAt(0)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean canFireBUECHI(String currentWord, String arcInscription) {
        if (SimulationSettingsManager.getSimulateWordMode()) {
            List<String> preparedWords = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord);
            for (String word : preparedWords) {
                if (word.endsWith("\u00b0")) continue;
                return false;
            }
            return FAAutomatonSimulationHelper.canFireNFA(currentWord, arcInscription);
        }
        return true;
    }

    private static boolean canFirePDA(Tuple currentTuple, String arcInscription) {
        String currentWord = (String)currentTuple.getComponent(0);
        StackDataStructure currentStack = (StackDataStructure)currentTuple.getComponent(1);
        String[] allRules = arcInscription.split("\n");
        List<String> preparedWords = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord);
        for (String preparedWord : preparedWords) {
            for (String rule : allRules) {
                if (preparedWord.isEmpty()) continue;
                PDARule letters = FAAutomatonSimulationHelper.generatePDARuleFromArcInscription(rule);
                if (!(SimulationSettingsManager.getSimulateWordMode() ? FAAutomatonSimulationHelper.isValidWordForPDASimulateWord(letters, currentStack, preparedWord) : FAAutomatonSimulationHelper.isValidWordForPDABuildWord(letters, currentStack))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isValidWordForPDASimulateWord(PDARule rule, StackDataStructure currentStack, String preparedWord) {
        if (rule.letter == '\u03b5' && (rule.requiredStackSymbol == '\u03b5' || currentStack.peek() == rule.requiredStackSymbol)) {
            return true;
        }
        if (rule.letter != '\u03b5' && rule.letter == preparedWord.charAt(0)) {
            if (rule.requiredStackSymbol == '\u03b5') {
                return true;
            }
            return currentStack.peek() == rule.requiredStackSymbol;
        }
        return false;
    }

    private static boolean isValidWordForPDABuildWord(PDARule letters, StackDataStructure stack) {
        return letters.requiredStackSymbol == '\u03b5' || stack.peek() == letters.requiredStackSymbol;
    }

    public static Tuple fire(Tuple currentTuple, String arcInscription) {
        String currentWord = (String)currentTuple.getComponent(0);
        currentWord = currentWord.replace(" ", "");
        arcInscription = arcInscription.replace(" ", "");
        FAAutomatonModelEnum model = SimulationSettingsManager.getAutomatonModel();
        switch (model) {
            case NFA: 
            case DFA: 
            case BUECHI: {
                currentWord = FAAutomatonSimulationHelper.fireNFA(currentWord, arcInscription);
                break;
            }
            case PDA: {
                return FAAutomatonSimulationHelper.firePDA(currentTuple, arcInscription);
            }
        }
        return new Tuple(new Object[]{currentWord, currentTuple.getComponent(1)}, null);
    }

    private static Tuple firePDA(Tuple currentTuple, String arcInscription) {
        String currentWord = (String)currentTuple.getComponent(0);
        StackDataStructure currentStack = (StackDataStructure)currentTuple.getComponent(1);
        String[] allRules = arcInscription.split("\n");
        List<String> preparedWords = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord);
        HashMap<String, PDAOperationResult> nextWords = new HashMap<String, PDAOperationResult>();
        if (SimulationSettingsManager.getSimulateWordMode()) {
            for (String preparedWord : preparedWords) {
                for (String rule : allRules) {
                    Optional<Map.Entry<String, PDAOperationResult>> validWordForRule = FAAutomatonSimulationHelper.retrieveNextValidWordForRule(rule, currentWord, preparedWord, currentStack);
                    validWordForRule.ifPresent(stringPDAOperationResultEntry -> nextWords.put((String)stringPDAOperationResultEntry.getKey(), (PDAOperationResult)stringPDAOperationResultEntry.getValue()));
                }
            }
        } else {
            for (String rule : allRules) {
                Optional<Map.Entry<String, PDAOperationResult>> nextPossibleWord = FAAutomatonSimulationHelper.buildNextPossibleWordForRule(rule, currentWord, currentStack);
                nextPossibleWord.ifPresent(nextPossibleWordEntry -> nextWords.put((String)nextPossibleWordEntry.getKey(), (PDAOperationResult)nextPossibleWordEntry.getValue()));
            }
        }
        return FAAutomatonSimulationHelper.selectAndFirePDAArc(nextWords);
    }

    private static Optional<Map.Entry<String, PDAOperationResult>> buildNextPossibleWordForRule(String currentInscription, String currentWord, StackDataStructure currentStack) {
        StackDataStructure clonedStack;
        PDARule rule = FAAutomatonSimulationHelper.generatePDARuleFromArcInscription(currentInscription);
        if (!FAAutomatonSimulationHelper.updateStack(rule, clonedStack = (StackDataStructure)currentStack.clone())) {
            return Optional.empty();
        }
        Object resultingWord = currentWord + rule.letter;
        if (((String)resultingWord).isBlank()) {
            resultingWord = String.valueOf('\u03b5');
        }
        String display = DISPLAY_FORMAT.formatted(currentWord, currentStack, rule, resultingWord, clonedStack);
        return Optional.of(new AbstractMap.SimpleEntry<String, PDAOperationResult>(display, new PDAOperationResult((String)resultingWord, clonedStack)));
    }

    private static Optional<Map.Entry<String, PDAOperationResult>> retrieveNextValidWordForRule(String currentInscription, String currentWord, String preparedWord, StackDataStructure currentStack) {
        String resultingWord = null;
        String oldWord = null;
        PDARule rule = FAAutomatonSimulationHelper.generatePDARuleFromArcInscription(currentInscription);
        StackDataStructure clonedStack = (StackDataStructure)currentStack.clone();
        if (rule.letter == '\u03b5' && (rule.requiredStackSymbol == '\u03b5' || currentStack.peek() == rule.requiredStackSymbol)) {
            FAAutomatonSimulationHelper.updateStack(rule, clonedStack);
            resultingWord = currentWord;
            oldWord = currentWord;
        }
        if (rule.letter != '\u03b5' && rule.letter == preparedWord.charAt(0)) {
            if (!FAAutomatonSimulationHelper.updateStack(rule, clonedStack)) {
                return Optional.empty();
            }
            resultingWord = preparedWord.substring(1);
            oldWord = preparedWord;
            if (resultingWord.isEmpty()) {
                resultingWord = String.valueOf('\u03b5');
            }
        }
        if (resultingWord != null) {
            String formattedRule = rule.toString();
            String display = DISPLAY_FORMAT.formatted(oldWord, currentStack, formattedRule, resultingWord, clonedStack);
            return Optional.of(new AbstractMap.SimpleEntry<String, PDAOperationResult>(display, new PDAOperationResult(resultingWord, clonedStack)));
        }
        return Optional.empty();
    }

    private static boolean updateStack(PDARule rule, StackDataStructure stack) {
        if (rule.requiredStackSymbol != '\u03b5' && stack.peek() == rule.requiredStackSymbol) {
            stack.pop();
        } else if (rule.requiredStackSymbol != '\u03b5' && stack.peek() != rule.requiredStackSymbol) {
            return false;
        }
        if (rule.newStackSymbol != '\u03b5') {
            stack.push(rule.newStackSymbol);
        }
        return true;
    }

    private static Tuple selectAndFirePDAArc(HashMap<String, PDAOperationResult> nextWords) {
        if (nextWords.keySet().size() > 1) {
            PDAOperationResult chosenResult;
            if (SimulationSettingsManager.getManualSimulation()) {
                String chosenOperation = (String)FAAutomatonSimulationHelper.showBindingOptionsWindow(nextWords.keySet().toArray());
                chosenResult = nextWords.get(chosenOperation);
            } else {
                int r = (int)(Math.random() * (double)nextWords.keySet().size());
                chosenResult = nextWords.get((String)nextWords.keySet().toArray()[r]);
            }
            String resultingWord = chosenResult.resultingWord;
            if (resultingWord.equals(String.valueOf('\u03b5'))) {
                resultingWord = "";
            }
            return new Tuple(new Object[]{resultingWord, chosenResult.resultingStack}, null);
        }
        String chosenWord = (String)nextWords.keySet().toArray()[0];
        PDAOperationResult result = nextWords.get(chosenWord);
        return new Tuple(new Object[]{result.resultingWord, result.resultingStack}, null);
    }

    private static String fireNFA(String currentWord, String arcInscription) {
        int i;
        List<String> allowedByArc = FAAutomatonSimulationHelper.splitNFAArcInscription(arcInscription);
        List<String> preparedWords = FAAutomatonSimulationHelper.prepareTokenForConsumption((String)currentWord);
        if (SimulationSettingsManager.getSimulateWordMode()) {
            preparedWords.removeIf(s -> {
                if (allowedByArc.contains("")) {
                    return false;
                }
                if (!s.isEmpty()) {
                    for (String arcInscr : allowedByArc) {
                        if (s.charAt(0) != arcInscr.charAt(0)) continue;
                        return false;
                    }
                }
                return true;
            });
            HashMap<CallSite, Object> nextWords = new HashMap<CallSite, Object>();
            HashSet<CallSite> options = new HashSet<CallSite>();
            for (String preparedWord : preparedWords) {
                for (String arcInscr : allowedByArc) {
                    String display;
                    if (arcInscr.isEmpty()) {
                        String display2 = "[" + (String)currentWord + ", \u03b5] \u2192 " + (String)currentWord;
                        if (!options.add((CallSite)((Object)display2))) continue;
                        nextWords.putIfAbsent((CallSite)((Object)display2), currentWord);
                        continue;
                    }
                    if (preparedWord.isBlank() || preparedWord.charAt(0) != arcInscr.charAt(0)) continue;
                    String resultingWord = preparedWord.substring(1);
                    if (resultingWord.isEmpty()) {
                        resultingWord = "\u03b5";
                    }
                    if (!options.add((CallSite)((Object)(display = "[" + preparedWord + ", " + arcInscr.charAt(0) + "] \u2192 " + resultingWord)))) continue;
                    nextWords.putIfAbsent((CallSite)((Object)display), preparedWord.substring(1));
                }
            }
            if (options.size() > 1) {
                if (SimulationSettingsManager.getManualSimulation()) {
                    return (String)nextWords.get((String)FAAutomatonSimulationHelper.showBindingOptionsWindow(options.toArray()));
                }
                int r = (int)(Math.random() * (double)options.size());
                return (String)nextWords.get((String)options.toArray()[r]);
            }
            if (allowedByArc.contains("")) {
                return currentWord;
            }
            return preparedWords.get(0).substring(1);
        }
        if (preparedWords.size() > 1) {
            boolean topLevelUnion = false;
            int insideBracket = 0;
            block7: for (i = 0; i < ((String)currentWord).length(); ++i) {
                switch (((String)currentWord).charAt(i)) {
                    case '(': {
                        ++insideBracket;
                        continue block7;
                    }
                    case ')': {
                        --insideBracket;
                        continue block7;
                    }
                    case '+': 
                    case '|': {
                        if (insideBracket != 0) continue block7;
                        topLevelUnion = true;
                    }
                }
            }
            if (topLevelUnion && !((String)currentWord).startsWith("(")) {
                currentWord = "(" + (String)currentWord + ")";
            }
        }
        if (allowedByArc.size() > 1) {
            if (SimulationSettingsManager.getManualSimulation()) {
                Object[] options = new String[allowedByArc.size()];
                HashMap<Object, Object> nextWords = new HashMap<Object, Object>();
                for (i = 0; i < allowedByArc.size(); ++i) {
                    String letter;
                    Object word = (String)currentWord + allowedByArc.get(i);
                    if (((String)word).isBlank()) {
                        word = "\u03b5";
                    }
                    if ((letter = allowedByArc.get(i)).isEmpty()) {
                        letter = "\u03b5";
                    }
                    options[i] = "[" + (String)currentWord + ", " + letter + "] \u2192 " + (String)word;
                    nextWords.put(options[i], word);
                }
                return (String)nextWords.get((String)FAAutomatonSimulationHelper.showBindingOptionsWindow(options));
            }
            int r = (int)(Math.random() * (double)allowedByArc.size());
            return (String)currentWord + allowedByArc.get(r);
        }
        return (String)currentWord + allowedByArc.get(0);
    }

    public static List<String> prepareTokenForConsumption(String currentWord) {
        ArrayList<String> result = new ArrayList<String>();
        if (currentWord == null) {
            throw new IllegalStateException("Word can't be null!");
        }
        if (currentWord.isEmpty()) {
            result.add("");
            return result;
        }
        int openBracket = 0;
        ArrayList<Integer> unionOperators = new ArrayList<Integer>();
        block10: for (int i = 0; i < currentWord.length(); ++i) {
            switch (currentWord.charAt(i)) {
                case '(': {
                    ++openBracket;
                    continue block10;
                }
                case ')': {
                    --openBracket;
                    continue block10;
                }
                case '+': {
                    if (openBracket != 0 || i != 0 && currentWord.charAt(i - 1) == '^') continue block10;
                    unionOperators.add(i);
                    continue block10;
                }
                case '|': {
                    if (openBracket != 0) continue block10;
                    unionOperators.add(i);
                }
            }
        }
        if (!unionOperators.isEmpty()) {
            int wordIndex = 0;
            for (Integer unionIndex : unionOperators) {
                result.addAll(FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(wordIndex, unionIndex)));
                wordIndex = unionIndex + 1;
            }
            result.addAll(FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(wordIndex)));
            return result;
        }
        int groupIndex = 0;
        boolean insideKleene = true;
        while (insideKleene && groupIndex < currentWord.length()) {
            insideKleene = false;
            if (currentWord.charAt(groupIndex) == '(') {
                List<String> temp;
                openBracket = 1;
                int j = groupIndex + 1;
                while (openBracket > 0) {
                    switch (currentWord.charAt(j)) {
                        case '(': {
                            ++openBracket;
                            break;
                        }
                        case ')': {
                            --openBracket;
                        }
                    }
                    ++j;
                }
                if (j + 1 < currentWord.length()) {
                    if (currentWord.charAt(groupIndex + 1) == ')') {
                        insideKleene = true;
                        if (currentWord.charAt(j) == '^') {
                            ++j;
                        }
                        if (currentWord.charAt(j) == '*') {
                            ++j;
                        }
                        if (currentWord.charAt(j) == '+') {
                            ++j;
                        }
                        if (currentWord.charAt(j) == '\u00b0') {
                            // empty if block
                        }
                        groupIndex = ++j;
                        continue;
                    }
                    if (currentWord.charAt(j) == '^') {
                        if (currentWord.charAt(j + 1) == '*') {
                            insideKleene = true;
                            temp = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1));
                            for (String prefix : temp) {
                                result.add(prefix + currentWord.substring(groupIndex));
                            }
                            groupIndex = j + 2;
                            if (groupIndex != currentWord.length()) continue;
                            result.add("");
                            continue;
                        }
                        if (currentWord.charAt(j + 1) == '+') {
                            if (j + 2 == currentWord.length()) {
                                temp = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1));
                                for (String prefix : temp) {
                                    result.add(prefix + currentWord.substring(groupIndex, j + 1) + "*");
                                }
                            } else {
                                temp = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1));
                                for (String prefix : temp) {
                                    result.add(prefix + currentWord.substring(groupIndex, j + 1) + "*" + currentWord.substring(j + 2));
                                }
                            }
                            if (!temp.contains("")) continue;
                            result.add("");
                            continue;
                        }
                        throw new IllegalStateException("Read '^' without '+' or '*'.");
                    }
                    if (currentWord.charAt(j) == '*') {
                        insideKleene = true;
                        temp = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1));
                        for (String prefix : temp) {
                            result.add(prefix + currentWord.substring(groupIndex));
                        }
                        groupIndex = j + 1;
                        if (groupIndex != currentWord.length()) continue;
                        result.add("");
                        continue;
                    }
                    temp = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1));
                    for (String prefix : temp) {
                        result.add(prefix + currentWord.substring(j));
                    }
                    continue;
                }
                if (j < currentWord.length()) {
                    if (currentWord.charAt(j) == '*') {
                        insideKleene = true;
                        temp = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1));
                        for (String prefix : temp) {
                            result.add(prefix + currentWord.substring(groupIndex));
                        }
                        groupIndex = j + 1;
                        result.add("");
                        continue;
                    }
                    if (currentWord.charAt(j) == '\u00b0') {
                        temp = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1));
                        for (String prefix : temp) {
                            result.add(prefix + currentWord.substring(groupIndex));
                        }
                        groupIndex = j + 1;
                        continue;
                    }
                    temp = FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1));
                    for (String prefix : temp) {
                        result.add(prefix + currentWord.substring(j));
                    }
                    continue;
                }
                result.addAll(FAAutomatonSimulationHelper.prepareTokenForConsumption(currentWord.substring(groupIndex + 1, j - 1)));
                continue;
            }
            if (groupIndex + 2 < currentWord.length()) {
                if (currentWord.charAt(groupIndex + 1) == '^') {
                    if (currentWord.charAt(groupIndex + 2) == '*') {
                        insideKleene = true;
                        result.add(currentWord.charAt(groupIndex) + currentWord.substring(groupIndex));
                        if ((groupIndex += 3) != currentWord.length()) continue;
                        result.add("");
                        continue;
                    }
                    if (currentWord.charAt(groupIndex + 2) == '+') {
                        if (groupIndex + 3 == currentWord.length()) {
                            result.add("" + currentWord.charAt(groupIndex) + currentWord.charAt(groupIndex) + "^*");
                            continue;
                        }
                        result.add("" + currentWord.charAt(groupIndex) + currentWord.charAt(groupIndex) + "^*" + currentWord.substring(groupIndex + 3));
                        continue;
                    }
                    if (currentWord.charAt(groupIndex + 2) == '\u00b0') {
                        result.add(currentWord.charAt(groupIndex) + currentWord.substring(groupIndex));
                        continue;
                    }
                    throw new IllegalStateException("Read '^' without '+' or '*'.");
                }
                if (currentWord.charAt(groupIndex + 1) == '*') {
                    insideKleene = true;
                    result.add(currentWord.charAt(groupIndex) + currentWord.substring(groupIndex));
                    if ((groupIndex += 2) != currentWord.length()) continue;
                    result.add("");
                    continue;
                }
                if (currentWord.charAt(groupIndex + 1) == '\u00b0') {
                    result.add(currentWord.charAt(groupIndex) + currentWord.substring(groupIndex));
                    continue;
                }
                result.add(currentWord.substring(groupIndex));
                continue;
            }
            if (groupIndex + 1 < currentWord.length()) {
                if (currentWord.charAt(groupIndex + 1) == '*') {
                    insideKleene = true;
                    result.add(currentWord.charAt(groupIndex) + currentWord.substring(groupIndex));
                    groupIndex += 2;
                    result.add("");
                    continue;
                }
                if (currentWord.charAt(groupIndex + 1) == '\u00b0') {
                    result.add(currentWord.charAt(groupIndex) + currentWord.substring(groupIndex));
                    continue;
                }
                result.add(currentWord.substring(groupIndex));
                continue;
            }
            result.add("" + currentWord.charAt(groupIndex));
        }
        return result;
    }

    private static Object showBindingOptionsWindow(Object[] options) {
        JFrame jFrame = new JFrame("Multiple possible bindings:");
        JLabel text = new JLabel("Multiple possible bindings found. Chose one:");
        Object result = JOptionPane.showInputDialog(jFrame, text, "Possible Bindings", 1, null, options, options[0]);
        if (result == null) {
            return options[0];
        }
        return result;
    }

    public static List<String> splitNFAArcInscription(String arcInscription) {
        if (arcInscription == null) {
            throw new IllegalStateException("Arc inscription may not be null!");
        }
        arcInscription = arcInscription.replaceAll("\\s", "");
        arcInscription = arcInscription.replaceAll("\n", "");
        String[] parts = arcInscription.split(",");
        HashSet<String> allowed = new HashSet<String>(Arrays.asList(parts));
        if (parts.length * 2 - 1 != arcInscription.length()) {
            allowed.add("");
        }
        return allowed.stream().toList();
    }

    private static PDARule generatePDARuleFromArcInscription(String arcInscription) {
        if (arcInscription == null) {
            throw new IllegalStateException("Arc inscription may not be null!");
        }
        String[] extractedLetters = new String[3];
        int colonIndex = arcInscription.indexOf(44);
        extractedLetters[0] = arcInscription.substring(0, colonIndex).strip();
        int arrowIndex = arcInscription.indexOf("->");
        extractedLetters[1] = arcInscription.substring(colonIndex + 1, arrowIndex).strip();
        extractedLetters[2] = arcInscription.substring(arrowIndex + 2).strip();
        for (int i = 0; i < extractedLetters.length; ++i) {
            if (!extractedLetters[i].isEmpty()) continue;
            extractedLetters[i] = String.valueOf('\u03b5');
        }
        return new PDARule(extractedLetters[0].charAt(0), extractedLetters[1].charAt(0), extractedLetters[2].charAt(0));
    }

    private record PDARule(char letter, char requiredStackSymbol, char newStackSymbol) {
        @Override
        public String toString() {
            return FAAutomatonSimulationHelper.PDA_RULE_FORMAT.formatted(Character.valueOf(this.letter), Character.valueOf(this.requiredStackSymbol), Character.valueOf(this.newStackSymbol));
        }
    }

    private record PDAOperationResult(String resultingWord, StackDataStructure resultingStack) {
    }
}

