/*
 * Decompiled with CFR 0.152.
 */
package de.renew.faformalism.compiler;

import de.renew.expression.CallExpression;
import de.renew.expression.ConstantExpression;
import de.renew.expression.EqualsExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.LocalVariable;
import de.renew.expression.TupleExpression;
import de.renew.expression.VariableExpression;
import de.renew.faformalism.shadow.FAShadowLookupExtension;
import de.renew.faformalism.shadow.ShadowFAArc;
import de.renew.faformalism.shadow.ShadowFAState;
import de.renew.faformalism.util.FAAutomatonModelEnum;
import de.renew.faformalism.util.FAAutomatonSimulationHelper;
import de.renew.faformalism.util.FASyntaxChecker;
import de.renew.faformalism.util.SimulationSettingsManager;
import de.renew.faformalism.util.StackDataStructure;
import de.renew.formalism.function.DynamicStaticMethodFunction;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaNetHelper;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.SingleJavaNetCompiler;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.ExpressionTokenSource;
import de.renew.net.ManualInscription;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.Arc;
import de.renew.net.inscription.ActionInscription;
import de.renew.net.inscription.GuardInscription;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.SyntaxException;
import de.renew.util.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class SingleAutomatonCompiler
extends SingleJavaNetCompiler {
    private static final Logger LOGGER = Logger.getLogger(SingleAutomatonCompiler.class);
    private static int _stateNum = 0;
    private static int _transNum = 0;

    public SingleAutomatonCompiler() {
        this(false, false, false);
    }

    public SingleAutomatonCompiler(boolean allowDangerousArcs, boolean allowTimeInscriptions, boolean wantEarlyTokens) {
        super(allowDangerousArcs, allowTimeInscriptions, wantEarlyTokens);
    }

    public void compile(ShadowNet shadowNet) throws SyntaxException {
        if (this.hasMultipleStartstates(shadowNet.elements().iterator())) {
            LOGGER.debug((Object)"Found multiple startstate! ~~~~~~~~~~~~~\u00ab\u00ab\u00ab");
            throw new SyntaxException("Cannot simulate automaton with multiple startstates.");
        }
        Net net = this.getLookup().getNet(shadowNet.getName());
        LOGGER.debug((Object)("compile(ShadowNet) compiling " + String.valueOf(net)));
        this.parseDeclarations(shadowNet);
        for (ShadowNetElement elem : shadowNet.elements()) {
            if (!(elem instanceof ShadowFAState)) continue;
            ShadowFAState faState = (ShadowFAState)elem;
            try {
                FASyntaxChecker.checkWordSyntax(faState._word);
            }
            catch (SyntaxException se) {
                se.addObject((Object)faState);
                throw se;
            }
            this.compile(faState, net);
        }
        LOGGER.debug((Object)"\u00bb~ All shadow states compiled ~\u00ab");
        for (ShadowNetElement elem : shadowNet.elements()) {
            if (!(elem instanceof ShadowFAArc)) continue;
            ShadowFAArc shadowFAArc = (ShadowFAArc)elem;
            try {
                this.compile(shadowFAArc, net);
            }
            catch (SyntaxException se) {
                se.addObject((Object)shadowFAArc);
                throw se;
            }
        }
        LOGGER.debug((Object)"\u00bb~ All shadow states compiled ~\u00ab");
        LOGGER.debug((Object)("\u00bb\u00bb~ Compilation of " + shadowNet.getName() + " finished! ~\u00ab\u00ab"));
    }

    protected void compile(ShadowFAState shadowFAState, Net net) throws SyntaxException {
        LOGGER.debug((Object)("compile(ShadowFAState, Net) compiling " + String.valueOf((Object)shadowFAState)));
        Object sname = shadowFAState.getName();
        if (sname == null) {
            sname = "State" + ++_stateNum;
        }
        Place place = new Place(net, (String)sname, new NetElementID(shadowFAState.getID()));
        place.setTrace(shadowFAState.getTrace());
        if (shadowFAState._stateType == 1 || shadowFAState._stateType == 3) {
            String word = shadowFAState._word;
            StackDataStructure dataStructure = null;
            if (SimulationSettingsManager.getAutomatonModel() == FAAutomatonModelEnum.PDA) {
                dataStructure = new StackDataStructure();
            }
            ConstantExpression wordExpression = new ConstantExpression(String.class, (Object)word);
            ConstantExpression stackExpression = new ConstantExpression(StackDataStructure.class, (Object)dataStructure);
            TupleExpression tupleExpression = new TupleExpression((Expression)wordExpression, (Expression)stackExpression);
            ExpressionTokenSource tokenSource = new ExpressionTokenSource((Expression)tupleExpression);
            place.add((TokenSource)tokenSource);
        }
        FAShadowLookupExtension.lookup(this.lookup).set(shadowFAState, place);
        this.compileFAStateInscriptions(shadowFAState, place);
    }

    protected void compile(ShadowFAArc shadowFAArc, Net net) throws SyntaxException {
        LOGGER.debug((Object)("compile(ShadowFAArc, Net) compiling " + String.valueOf((Object)shadowFAArc)));
        LOGGER.debug((Object)("ShadowFAArcs name is " + shadowFAArc.getName()));
        Object tname = shadowFAArc.toString();
        if (tname == null) {
            tname = "Arc" + ++_transNum;
        }
        String arcInscr = this.getArcInscription(shadowFAArc);
        FASyntaxChecker.checkArcSyntax(arcInscr);
        Transition transition = new Transition(net, (String)tname, new NetElementID(shadowFAArc.getID()));
        if (SimulationSettingsManager.getManualSimulation()) {
            transition.add((TransitionInscription)ManualInscription.getInstance());
        }
        VariableExpression currentWord = new VariableExpression(Types.UNTYPED, new LocalVariable("x"));
        String letter = this.getArcInscription(shadowFAArc);
        ConstantExpression cE = letter == null ? new ConstantExpression(String.class, (Object)"") : new ConstantExpression(String.class, (Object)letter);
        Expression[] params = new Expression[]{currentWord, cE};
        TupleExpression sig = new TupleExpression(params);
        DynamicStaticMethodFunction canFireCall = new DynamicStaticMethodFunction("canFire", FAAutomatonSimulationHelper.class);
        CallExpression canFire = new CallExpression(Types.UNTYPED, (Expression)sig, (Function)canFireCall);
        GuardInscription guard = new GuardInscription((Expression)canFire);
        transition.add((TransitionInscription)guard);
        VariableExpression left = new VariableExpression(Types.UNTYPED, new LocalVariable("y", true));
        DynamicStaticMethodFunction fireCall = new DynamicStaticMethodFunction("fire", FAAutomatonSimulationHelper.class);
        CallExpression right = new CallExpression(Types.UNTYPED, (Expression)sig, (Function)fireCall);
        EqualsExpression eEx = new EqualsExpression(Types.UNTYPED, (Expression)left, (Expression)right);
        ActionInscription action = new ActionInscription((Expression)eEx, transition);
        transition.add((TransitionInscription)action);
        FAShadowLookupExtension.lookup(this.lookup).set(shadowFAArc, transition);
        Place src = FAShadowLookupExtension.lookup(this.lookup).get(shadowFAArc._src);
        VariableExpression incomingX = new VariableExpression(Types.UNTYPED, new LocalVariable("x", true));
        Arc arc = new Arc(src, transition, -1, (Expression)incomingX, ConstantExpression.doubleZeroExpression);
        arc.setTrace(shadowFAArc.getTrace());
        transition.add((TransitionInscription)arc);
        Place dest = FAShadowLookupExtension.lookup(this.lookup).get(shadowFAArc._dest);
        VariableExpression incomingY = new VariableExpression(Types.UNTYPED, new LocalVariable("y", true));
        arc = new Arc(dest, transition, 1, (Expression)incomingY, ConstantExpression.doubleZeroExpression);
        arc.setTrace(shadowFAArc.getTrace());
        transition.add((TransitionInscription)arc);
    }

    protected void compileFAStateInscriptions(ShadowFAState shadowFAState, Place place) throws SyntaxException {
        LOGGER.debug((Object)("compileFAStateInscriptions(ShadowFAState, Place) called with " + String.valueOf((Object)shadowFAState) + " and " + String.valueOf(place)));
        for (ShadowNetElement elem : shadowFAState.elements()) {
            LOGGER.debug((Object)(String.valueOf((Object)this) + " has " + String.valueOf(elem) + " as child"));
            if (elem instanceof ShadowInscription) {
                String inscr = ((ShadowInscription)elem).inscr;
                try {
                    for (Object expr : this.parseFAStateInscription(inscr)) {
                        if (!(expr instanceof TypedExpression)) continue;
                        TypedExpression typedExpr = (TypedExpression)expr;
                        Expression castedExpression = null;
                        try {
                            castedExpression = JavaNetHelper.makeCastedOutputExpression((Class)Types.UNTYPED, (TypedExpression)typedExpr);
                        }
                        catch (SyntaxException e) {
                            throw e.addObject((Object)elem);
                        }
                        place.add((TokenSource)new ExpressionTokenSource(castedExpression));
                        LOGGER.debug((Object)("Added " + String.valueOf(castedExpression) + " to " + String.valueOf((Object)shadowFAState)));
                    }
                    continue;
                }
                catch (SyntaxException e) {
                    throw e.addObject((Object)elem);
                }
            }
            if (elem instanceof ShadowFAArc) continue;
            throw new SyntaxException("Unsupported place inscription: " + String.valueOf(elem.getClass())).addObject((Object)shadowFAState).addObject((Object)elem);
        }
    }

    private Collection<Object> parseFAStateInscription(String inscr) throws SyntaxException {
        LOGGER.debug((Object)("parseFAStateInscription(String) called with " + inscr));
        if (inscr != null && !inscr.equals("")) {
            LOGGER.debug((Object)("FAState has inscription \u00bb " + inscr + " \u00ab"));
            InscriptionParser parser = this.makeParser(inscr);
            parser.setDeclarationNode(this.declaration);
            try {
                return parser.PlaceInscription();
            }
            catch (ParseException e) {
                throw SingleAutomatonCompiler.makeSyntaxException((ParseException)e);
            }
        }
        return Collections.emptySet();
    }

    private String getArcInscription(ShadowFAArc shadowFAArc) {
        Set insc = shadowFAArc.elements();
        String letter = null;
        for (ShadowNetElement snw : insc) {
            if (!(snw instanceof ShadowInscription)) continue;
            ShadowInscription si = (ShadowInscription)snw;
            letter = si.inscr;
        }
        return letter;
    }

    private boolean hasMultipleStartstates(Iterator<ShadowNetElement> shadowNetElements) {
        int startstateCount = 0;
        while (shadowNetElements.hasNext()) {
            ShadowNetElement elem = shadowNetElements.next();
            if (!(elem instanceof ShadowFAState)) continue;
            ShadowFAState shFAState = (ShadowFAState)elem;
            if (shFAState._stateType != 1 && shFAState._stateType != 3 || ++startstateCount <= 1) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

