/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.engine.common.SimulatorEvent;
import de.renew.logging.gui.LoggerRepository;
import de.renew.logging.gui.MainRepository;
import de.renew.logging.gui.MainRepositoryManager;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class GuiAppender
implements Appender {
    private static final Logger LOGGER = Logger.getLogger(GuiAppender.class);
    private List<Filter> _filters = new Vector<Filter>();
    private String _name = null;
    private int _stepPufferSize = 20;

    public void addFilter(Filter filter) {
        this._filters.add(filter);
    }

    public Filter getFilter() {
        if (this._filters.isEmpty()) {
            return null;
        }
        return this._filters.get(0);
    }

    public void clearFilters() {
        this._filters.clear();
    }

    public String getName() {
        return this._name;
    }

    public void setErrorHandler(ErrorHandler eHandler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setLayout(Layout layout) {
    }

    public Layout getLayout() {
        return null;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }

    public int getPufferSize() {
        return this._stepPufferSize;
    }

    public void setPufferSize(int bufferSize) {
        this._stepPufferSize = bufferSize;
    }

    public void doAppend(LoggingEvent event) {
        SimulatorEvent simEvent = (SimulatorEvent)event.getMessage();
        MainRepository mRepository = MainRepositoryManager.getInstance().getRepository(simEvent);
        if (mRepository == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(String.valueOf(this) + ": Discarding event because no matching repository exists: " + String.valueOf(simEvent)));
            }
            return;
        }
        String[] definedLoggerNames = GuiAppender.getDefinedLoggers(event.getLoggerName());
        for (int x = 0; x < definedLoggerNames.length; ++x) {
            LoggerRepository repository = mRepository.getLoggerRepository(definedLoggerNames[x], this._stepPufferSize);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)(String.valueOf(this) + ": Dispatching event to " + String.valueOf(repository) + ": " + String.valueOf(simEvent)));
            }
            repository.addEvent(simEvent);
        }
    }

    private static String[] getDefinedLoggers(String eventLoggerName) {
        Vector<String> loggers = new Vector<String>();
        for (Logger logger = Logger.getLogger((String)eventLoggerName); logger != null; logger = logger.getParent()) {
            Enumeration enumeration = logger.getAllAppenders();
            boolean found = false;
            while (enumeration.hasMoreElements() && !found) {
                Appender appender = (Appender)enumeration.nextElement();
                if (!(appender instanceof GuiAppender)) continue;
                found = true;
                loggers.add(logger.getName());
            }
        }
        return loggers.toArray(new String[0]);
    }
}

