/*
 * Decompiled with CFR 0.152.
 */
package de.renew.imagenetdiff;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.DrawingHelper;
import de.renew.export.io.exportFormats.PNGExportFormat;
import de.renew.imagenetdiff.AbstractDiffCommand;
import de.renew.imagenetdiff.EPSDiffCommand;
import de.renew.imagenetdiff.ImageNetDiffPlugin;
import de.renew.plugin.PluginManager;
import de.renew.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class PNGDiffCommand
extends AbstractDiffCommand {
    static final String IMAGE_EXTENSION = ".png";
    static final Logger LOGGER = Logger.getLogger(PNGDiffCommand.class);

    public PNGDiffCommand() {
        super("Simple PNG Diff");
        this.setImageExtension(IMAGE_EXTENSION);
    }

    @Override
    public File doDiff(StatusDisplayer sd, Drawing drawinga, Drawing drawingb, boolean quite) {
        if (drawinga != null && drawingb != null) {
            Drawing drawing2;
            Drawing drawing1;
            ImageNetDiffPlugin diffPlugin;
            PluginManager pluginManager = PluginManager.getInstance();
            boolean oldStyle = false;
            if (pluginManager != null && (diffPlugin = (ImageNetDiffPlugin)pluginManager.getPluginByName("Renew ImageNetDiff")) != null) {
                oldStyle = diffPlugin.getProperties().getBoolProperty("de.renew.imagenetdiff.background");
            }
            if (!oldStyle) {
                try {
                    drawing1 = PNGDiffCommand.removeBackground(drawinga);
                    drawing2 = PNGDiffCommand.removeBackground(drawingb);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(PNGDiffCommand.class.getSimpleName() + ": " + String.valueOf(e)));
                    }
                    drawing1 = drawinga;
                    drawing2 = drawingb;
                    oldStyle = true;
                }
            } else {
                drawing1 = drawinga;
                drawing2 = drawingb;
            }
            PNGExportFormat export = new PNGExportFormat();
            String fileName1 = drawing1.getName();
            String fileName2 = drawing2.getName();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(PNGDiffCommand.class.getSimpleName() + ": fileName1 " + fileName1));
                LOGGER.info((Object)(PNGDiffCommand.class.getSimpleName() + ": fileName2 " + fileName2));
            }
            Rectangle bounds1 = drawing1.getBounds();
            Rectangle bounds2 = drawing2.getBounds();
            int width = Math.max(bounds1.width + bounds1.x, bounds2.width + bounds2.x);
            int height = Math.max(bounds1.height + bounds1.y, bounds2.height + bounds2.y);
            Rectangle bounds = new Rectangle(0, 0, width, height);
            File tempFile1 = null;
            File tempFile2 = null;
            try {
                tempFile1 = File.createTempFile("export-", fileName1 + this.getImageExtension());
                tempFile2 = File.createTempFile("export-", fileName2 + this.getImageExtension());
            }
            catch (IOException e2) {
                LOGGER.error((Object)e2.getMessage());
                LOGGER.debug((Object)e2.getMessage(), (Throwable)e2);
            }
            if (tempFile1 != null && tempFile2 != null) {
                Process process;
                String nameDiff;
                String nameDiffNoExt;
                block29: {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info((Object)(PNGDiffCommand.class.getSimpleName() + ": tempFile1 " + tempFile1.getAbsolutePath()));
                    }
                    try {
                        export.internalExport(drawing1, tempFile1, bounds, false);
                        export.internalExport(drawing2, tempFile2, bounds, false);
                    }
                    catch (Exception e1) {
                        LOGGER.error((Object)e1.getMessage());
                        LOGGER.debug((Object)e1.getMessage(), (Throwable)e1);
                    }
                    String name1 = StringUtil.stripFilenameExtension((String)tempFile1.getAbsolutePath());
                    String name2 = StringUtil.stripFilenameExtension((String)tempFile2.getAbsolutePath());
                    nameDiffNoExt = name1 + "-diff";
                    nameDiff = name1 + "-diff" + this.getImageExtension();
                    if (oldStyle) {
                        this.exchangeColor(name1, 10, "white", "white");
                        this.exchangeColor(name2, 10, "white", "white");
                        if (drawing1.getFilename() != null && (drawing1.getFilename().getName().endsWith(".aip") || drawing1.getFilename().getName().endsWith(".rnw"))) {
                            LOGGER.debug((Object)"Doing AIP/RNW conversion.");
                            this.exchangeColor(name1, 10, "lightgray", "white");
                            this.exchangeColor(name1, 10, "lightgreen", "white");
                            this.exchangeColor(name2, 10, "lightgray", "white");
                            this.exchangeColor(name2, 10, "lightgreen", "white");
                            this.exchangeColor(name1, 10, "seagreen1", "white");
                            this.exchangeColor(name2, 10, "seagreen1", "white");
                            this.exchangeColor(name1, 10, "yellow", "white");
                            this.exchangeColor(name2, 10, "yellow", "white");
                        }
                    }
                    process = null;
                    try {
                        process = Runtime.getRuntime().exec("compare -alpha Remove " + name2 + this.getImageExtension() + " " + name1 + this.getImageExtension() + " " + nameDiff);
                    }
                    catch (Exception e1) {
                        LOGGER.error((Object)("Error while executing imagemagick compare: " + e1.getMessage()));
                        if (!LOGGER.isDebugEnabled()) break block29;
                        LOGGER.debug((Object)(PNGDiffCommand.class.getSimpleName() + ": " + e1.getMessage()), (Throwable)e1);
                    }
                }
                if (process != null) {
                    try {
                        int exit = process.waitFor();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)(EPSDiffCommand.class.getSimpleName() + ": process' exit code = " + exit));
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.exchangeColor(nameDiffNoExt, 10, "#d81030", "green");
                File diffFile = new File(nameDiff);
                if (!diffFile.exists()) {
                    sd.showStatus("Could not create diff image. ImageMagick installed?");
                } else if (!quite) {
                    BufferedImage img;
                    JFrame f;
                    block30: {
                        ImageNetDiffPlugin plugin = (ImageNetDiffPlugin)PluginManager.getInstance().getPluginByName("Renew ImageNetDiff");
                        plugin.addBlock();
                        f = PNGDiffCommand.getjFrame(drawing1, drawing2, plugin);
                        img = null;
                        try {
                            img = ImageIO.read(diffFile);
                        }
                        catch (IOException e1) {
                            LOGGER.error((Object)e1.getMessage());
                            if (!LOGGER.isDebugEnabled()) break block30;
                            LOGGER.debug((Object)(EPSDiffCommand.class.getName() + ": "), (Throwable)e1);
                        }
                    }
                    ImageComponent comp = new ImageComponent(img, width, height);
                    JScrollPane pane = new JScrollPane(comp);
                    f.add(pane);
                    f.setSize(new Dimension(width, height));
                    f.pack();
                    f.setVisible(true);
                } else {
                    sd.showStatus("Diff image created successfully. Name: " + diffFile.getName());
                }
                return diffFile;
            }
        } else {
            sd.showStatus("Operation canceled.");
        }
        return null;
    }

    private static JFrame getjFrame(Drawing drawing1, Drawing drawing2, final ImageNetDiffPlugin plugin) {
        final JFrame f = new JFrame("Diff Image: " + drawing1.getName() + " (red)  and " + drawing2.getName() + " (green)");
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                f.dispose();
                plugin.removeBlock();
            }
        });
        return f;
    }

    private static Drawing removeBackground(Drawing drawing) throws Exception {
        Drawing clone = DrawingHelper.cloneDrawing((Drawing)drawing);
        FigureEnumeration figures = clone.figures();
        while (figures.hasMoreElements()) {
            Figure figure = (Figure)figures.nextElement();
            figure.setAttribute("FillColor", (Object)ColorMap.NONE);
        }
        return clone;
    }

    public static class ImageComponent
    extends Component {
        private final BufferedImage _img;
        private final Dimension _dim;

        public ImageComponent(BufferedImage image, int dx, int dy) {
            this._img = image;
            this._dim = new Dimension(dx, dy);
        }

        @Override
        public Dimension getPreferredSize() {
            return this._dim;
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this._img, 0, 0, null);
        }
    }
}

