/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FigureException;
import de.renew.formalism.java.ConstructorSuggestion;
import de.renew.formalism.java.FieldSuggestion;
import de.renew.formalism.java.MethodSuggestion;
import de.renew.formalism.java.Suggestion;
import de.renew.formalism.java.VariableSuggestion;
import de.renew.gui.CPNApplication;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.GuiPlugin;
import de.renew.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class SyntaxExceptionFrame
extends FigureChangeAdapter {
    private final JFrame frame;
    private final JButton selectButton;
    private final JTextArea textArea;
    private final CPNApplication editor;
    private FigureException e = null;
    private JPanel myPanel;
    private JList<Suggestion> listOfSuggestions;
    private DefaultListModel<Suggestion> listModel;
    private JTextArea methodListHeader;
    private JScrollPane scrollPane;
    private final JButton applyButton;
    private QuickfixListener quickfixListener;

    SyntaxExceptionFrame(CPNApplication editor) {
        this.editor = editor;
        this.frame = new JFrame("Renew: Syntax Error");
        this.frame.setIconImage(Toolkit.getDefaultToolkit().createImage(editor.getIconImage().getSource()));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.frame.getContentPane().add("Center", this.textArea);
        JPanel southPanel = new JPanel(new GridLayout(1, 2));
        this.frame.getContentPane().add("South", southPanel);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(event -> this.frame.dispose());
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(event -> {
            GuiPlugin.getCurrent().getGui().showDrawingViewContainer(this.e.errorDrawing);
            if (this.e != null && !editor.selectOffendingElements(this.e)) {
                this.selectButton.setEnabled(false);
            }
        });
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(false);
        southPanel.add("1", closeButton);
        southPanel.add("2", this.selectButton);
        southPanel.add("3", this.applyButton);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                SyntaxExceptionFrame.this.dispose();
            }
        });
        this.frame.getRootPane().setDefaultButton(this.selectButton);
    }

    void displayException(FigureException e, boolean displayImmediately) {
        if (displayImmediately) {
            this.selectButton.setEnabled(this.editor.selectOffendingElements(e));
        } else {
            this.selectButton.setEnabled(true);
        }
        this.e = e;
        this.setFrame();
        FigureEnumerator errorFigures = new FigureEnumerator(e.errorFigures);
        while (errorFigures.hasMoreElements()) {
            errorFigures.nextFigure().addFigureChangeListener((FigureChangeListener)this);
        }
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void setFrame() {
        String headMessage = this.e.getMessage();
        this.frame.setTitle(this.e.title);
        Object o = this.e.getProblemSpecificInformation();
        if (o == null) {
            if (this.myPanel != null) {
                this.frame.remove(this.myPanel);
            }
            this.textArea.setText(headMessage);
            this.frame.getContentPane().add("Center", this.textArea);
            this.applyButton.setEnabled(false);
            this.frame.getRootPane().setDefaultButton(this.selectButton);
        } else {
            Collection collection;
            if (this.quickfixListener == null) {
                this.quickfixListener = new QuickfixListener();
                this.applyButton.addActionListener(this.quickfixListener);
            }
            this.applyButton.setEnabled(true);
            this.frame.getRootPane().setDefaultButton(this.applyButton);
            if (this.listOfSuggestions == null) {
                this.listOfSuggestions = new JList();
                this.listOfSuggestions.addMouseListener(this.quickfixListener);
                this.listOfSuggestions.addKeyListener(this.quickfixListener);
                this.frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        SyntaxExceptionFrame.this.listOfSuggestions.requestFocus();
                    }
                });
            }
            if (this.myPanel == null) {
                this.myPanel = new JPanel();
                this.myPanel.setLayout(new BorderLayout());
            }
            this.listModel = new DefaultListModel();
            if (this.methodListHeader == null) {
                this.methodListHeader = new JTextArea();
                this.methodListHeader.setEditable(false);
                this.methodListHeader.setEnabled(false);
            }
            if (this.scrollPane == null) {
                this.scrollPane = new JScrollPane();
                this.scrollPane.setViewportView(this.listOfSuggestions);
            }
            this.methodListHeader.setText(headMessage);
            this.frame.remove(this.textArea);
            if (o instanceof Collection && !(collection = (Collection)o).isEmpty()) {
                for (Object element : collection) {
                    if (!(element instanceof Suggestion)) continue;
                    Suggestion suggestion = (Suggestion)element;
                    this.listModel.addElement(suggestion);
                }
            }
            this.listOfSuggestions.setModel(this.listModel);
            if (!this.listModel.isEmpty()) {
                this.listOfSuggestions.setSelectedIndex(0);
            }
            this.myPanel.add((Component)this.methodListHeader, "North");
            this.myPanel.add((Component)this.scrollPane, "Center");
            this.frame.getContentPane().add("Center", this.myPanel);
        }
    }

    public void figureRemoved(FigureChangeEvent e) {
        this.dispose();
    }

    public void dispose() {
        if (this.e != null) {
            this.frame.dispose();
            FigureEnumerator errorFigures = new FigureEnumerator(this.e.errorFigures);
            while (errorFigures.hasMoreElements()) {
                errorFigures.nextFigure().removeFigureChangeListener((FigureChangeListener)this);
            }
            this.e = null;
        }
    }

    private class QuickfixListener
    implements MouseListener,
    KeyListener,
    ActionListener {
        private QuickfixListener() {
        }

        private void quickfix() {
            Suggestion selectedValue = SyntaxExceptionFrame.this.listOfSuggestions.getSelectedValue();
            SyntaxExceptionFrame.this.editor.getUndoRedoManager().commitUndoSnapshot(SyntaxExceptionFrame.this.editor.drawing());
            if (selectedValue instanceof Suggestion) {
                TextFigure tf;
                Object newText;
                int columnStart;
                boolean select;
                boolean edit;
                TextFigure th = SyntaxExceptionFrame.this.e.textErrorFigure;
                String text = th.getText();
                int i = this.getIndexFromLineAndColumn(text, SyntaxExceptionFrame.this.e.line, SyntaxExceptionFrame.this.e.column);
                String textPrefix = text.substring(0, i);
                Object textSuffix = text.substring(i);
                int lineStart = SyntaxExceptionFrame.this.e.line;
                int lineEnd = SyntaxExceptionFrame.this.e.line;
                int columnEnd = SyntaxExceptionFrame.this.e.column;
                if (selectedValue instanceof MethodSuggestion) {
                    MethodSuggestion suggestion = (MethodSuggestion)selectedValue;
                    edit = true;
                    String name = suggestion.getAttemptedMethod();
                    Class[] attemptedParameterTypes = suggestion.getAttemptedTypes();
                    Class<?>[] selectedParameterTypes = suggestion.getMethod().getParameterTypes();
                    boolean parametersMatch = false;
                    if (attemptedParameterTypes.length == selectedParameterTypes.length) {
                        parametersMatch = true;
                        for (int k = 0; k < attemptedParameterTypes.length; ++k) {
                            if (this.collectTypes(attemptedParameterTypes[k]).contains(selectedParameterTypes[k])) continue;
                            parametersMatch = false;
                        }
                    }
                    if (parametersMatch) {
                        textSuffix = ((String)textSuffix).replaceFirst(name, suggestion.getName());
                        select = false;
                        columnStart = SyntaxExceptionFrame.this.e.column + ".".length() + suggestion.getName().length();
                    } else if (((String)textSuffix).startsWith("." + name + "()")) {
                        textSuffix = ((String)textSuffix).replaceFirst(name + "\\(\\)", suggestion.getCallWithParameters());
                        if (suggestion.getParameters().length > 0) {
                            select = true;
                            columnStart = SyntaxExceptionFrame.this.e.column + ".".length() + suggestion.getName().length() + "(".length();
                            columnEnd = columnStart + suggestion.getParameters()[0].length();
                        } else {
                            select = false;
                            columnStart = SyntaxExceptionFrame.this.e.column + ".".length() + suggestion.getName().length() + "()".length();
                        }
                    } else {
                        textSuffix = ((String)textSuffix).replaceFirst(name, suggestion.getCallWithParameters());
                        if (suggestion.getParameters().length > 0) {
                            select = true;
                            columnStart = SyntaxExceptionFrame.this.e.column + ".".length() + suggestion.getName().length() + "(".length();
                            columnEnd = columnStart + suggestion.getParameters()[0].length();
                        } else {
                            select = false;
                            columnStart = SyntaxExceptionFrame.this.e.column + ".".length() + suggestion.getName().length() + "()".length();
                        }
                    }
                    newText = textPrefix + (String)textSuffix;
                    tf = th;
                } else if (selectedValue instanceof ConstructorSuggestion) {
                    ConstructorSuggestion constructorSuggestion = (ConstructorSuggestion)selectedValue;
                    select = false;
                    edit = false;
                    textPrefix = text.substring(0, text.indexOf(61) + 1);
                    textSuffix = " new " + constructorSuggestion.getCallWithParameters();
                    columnStart = textPrefix.length() + constructorSuggestion.getTypeName().length() + 7;
                    if (constructorSuggestion.getParameters().length > 0) {
                        select = true;
                        edit = true;
                        columnEnd = columnStart + constructorSuggestion.getParameters()[0].length();
                    }
                    newText = textPrefix + (String)textSuffix;
                    tf = th;
                } else if (selectedValue instanceof FieldSuggestion) {
                    FieldSuggestion fieldSuggestion = (FieldSuggestion)selectedValue;
                    textSuffix = ((String)textSuffix).replaceFirst(fieldSuggestion.getAttemptedName(), fieldSuggestion.getName());
                    select = false;
                    edit = true;
                    columnStart = SyntaxExceptionFrame.this.e.column + 1 + fieldSuggestion.getName().length();
                    newText = textPrefix + (String)textSuffix;
                    tf = th;
                } else if (selectedValue instanceof VariableSuggestion) {
                    VariableSuggestion sug = (VariableSuggestion)selectedValue;
                    select = true;
                    edit = sug.isEditDesired();
                    FigureEnumeration figures = SyntaxExceptionFrame.this.e.errorDrawing.figures();
                    DeclarationFigure declNode = null;
                    while (figures.hasMoreElements()) {
                        Figure fig = (Figure)figures.nextElement();
                        if (!(fig instanceof DeclarationFigure)) continue;
                        declNode = (DeclarationFigure)fig;
                        break;
                    }
                    if (declNode == null) {
                        throw new RuntimeException("no declaration node found.");
                    }
                    newText = declNode.getText();
                    lineEnd = lineStart = this.countLines((String)newText) + 1;
                    newText = (String)newText + "\n" + sug.getTypeName() + " " + sug.getName() + ";";
                    columnStart = 1;
                    columnEnd = sug.getTypeName().length() + 1;
                    if (sug.isImportNeeded()) {
                        String importStatement = "import " + sug.getType().getPackage().getName() + ".*;";
                        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(((String)newText).split("\n")));
                        int index = 0;
                        for (int j = lines.size() - 1; j >= 0; --j) {
                            String line = (String)lines.get(j);
                            if (!line.startsWith("import")) continue;
                            index = j;
                        }
                        if (index != 0) {
                            ++index;
                        }
                        lines.add(index, importStatement);
                        newText = StringUtil.join(lines, (String)"\n");
                    }
                    tf = declNode;
                } else {
                    throw new RuntimeException("unsupported suggestion type");
                }
                SyntaxExceptionFrame.this.editor.toolDone();
                tf.setText((String)newText);
                SyntaxExceptionFrame.this.editor.toolDone();
                if (edit) {
                    if (select) {
                        SyntaxExceptionFrame.this.editor.doTextEditSelected(tf, lineStart, columnStart, lineEnd, columnEnd);
                    } else {
                        SyntaxExceptionFrame.this.editor.doTextEdit(tf, lineStart, columnStart);
                    }
                }
            }
            SyntaxExceptionFrame.this.dispose();
            SyntaxExceptionFrame.this.listModel.clear();
        }

        private int getIndexFromLineAndColumn(String text, int line, int column) {
            int result = -1;
            String pattern = "^([^\n]*\n){" + (line - 1) + "}.{" + (column - 1) + "}";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(text);
            if (m.find()) {
                result = m.end();
            }
            return result;
        }

        private int countLines(String text) {
            int result = 1;
            String pattern = "\n";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(text);
            while (m.find()) {
                ++result;
            }
            return result;
        }

        private Set<Class<?>> collectTypes(Class<?> clazz) {
            HashSet allTypes = new HashSet();
            while (clazz != null) {
                allTypes.add(clazz);
                Class<?>[] interfaces = clazz.getInterfaces();
                List<Class<?>> interfacesAsList = Arrays.asList(interfaces);
                allTypes.addAll(interfacesAsList);
                clazz = clazz.getSuperclass();
            }
            return allTypes;
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getClickCount() == 2) {
                this.quickfix();
            }
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 10) {
                this.quickfix();
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.quickfix();
        }
    }
}

