/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.service;

import de.renew.fa.FADrawing;
import de.renew.fa.model.FA;
import de.renew.fa.model.Letter;
import de.renew.fa.util.FAHelper;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.fsa.impl.FastNFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.fsa.NFAs;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.GrowingMapAlphabet;

public class AutomataComparator {
    private AutomataComparator() {
    }

    public static String[] nfaLanguageEquivalence(FADrawing nfa1, FADrawing nfa2) {
        CompactDFA dfa2;
        FA fa1 = FAHelper.getModel(nfa1);
        Iterator<Letter> fa1Letters = fa1.getAlphabet();
        FA fa2 = FAHelper.getModel(nfa2);
        Iterator<Letter> fa2Letters = fa2.getAlphabet();
        GrowingMapAlphabet alphabet = new GrowingMapAlphabet();
        while (fa1Letters.hasNext()) {
            alphabet.add((Object)fa1Letters.next().getName());
        }
        while (fa2Letters.hasNext()) {
            alphabet.add((Object)fa2Letters.next().getName());
        }
        FastNFA<String> fastNfa1 = FAHelper.convertFAModelToAutomaton(fa1, (Alphabet<String>)alphabet);
        FastNFA<String> fastNfa2 = FAHelper.convertFAModelToAutomaton(fa2, (Alphabet<String>)alphabet);
        CompactDFA dfa1 = NFAs.determinize(fastNfa1);
        Word words = Automata.findSeparatingWord((UniversalDeterministicAutomaton)dfa1, (UniversalDeterministicAutomaton)(dfa2 = NFAs.determinize(fastNfa2)), (Collection)alphabet);
        if (words != null) {
            StringBuilder word = new StringBuilder();
            for (String s : words) {
                word.append(s);
            }
            String[] result = new String[2];
            result[1] = word.toString();
            if (dfa1.accepts((Iterable)words)) {
                if (fa1.getName() == null || fa1.getName().equals("")) {
                    fa1.setName("Template");
                }
                result[0] = fa1.getName();
            } else {
                result[0] = fa2.getName();
            }
            return result;
        }
        return null;
    }
}

