/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitDiffEditFilter;
import org.gitective.core.filter.commit.CommitFilter;
import org.gitective.core.filter.commit.CommitImpact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitLineImpactFilter
extends CommitDiffEditFilter
implements Iterable<CommitImpact> {
    private final int limit;
    private final SortedSet<CommitImpact> commits = new TreeSet<CommitImpact>(new CommitImpact.DescendingImpactComparator());
    private int add;
    private int edit;
    private int delete;

    public CommitLineImpactFilter(boolean detectRenames, int limit) {
        super(detectRenames);
        this.limit = limit;
    }

    public CommitLineImpactFilter(boolean detectRenames) {
        this(detectRenames, 10);
    }

    public CommitLineImpactFilter() {
        this(false);
    }

    public CommitLineImpactFilter(int limit) {
        this(false, limit);
    }

    public int getLimit() {
        return this.limit;
    }

    public SortedSet<CommitImpact> getCommits() {
        return this.commits;
    }

    @Override
    protected CommitDiffEditFilter markStart(RevCommit commit) {
        this.add = 0;
        this.edit = 0;
        this.delete = 0;
        return super.markStart(commit);
    }

    @Override
    protected CommitDiffEditFilter markEnd(RevCommit commit) {
        this.commits.add(new CommitImpact((AnyObjectId)commit, this.add, this.edit, this.delete));
        if (this.commits.size() > this.limit) {
            this.commits.remove(this.commits.last());
        }
        return super.markEnd(commit);
    }

    @Override
    protected boolean include(RevCommit commit, DiffEntry diff, Edit hunk) {
        switch (hunk.getType()) {
            case DELETE: {
                this.delete += hunk.getLengthA();
                break;
            }
            case INSERT: {
                this.add += hunk.getLengthB();
                break;
            }
            case REPLACE: {
                this.edit += hunk.getLengthB();
            }
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new CommitLineImpactFilter(this.detectRenames, this.limit);
    }

    @Override
    public CommitFilter reset() {
        this.commits.clear();
        return super.reset();
    }

    @Override
    public Iterator<CommitImpact> iterator() {
        return this.commits.iterator();
    }
}

