/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.navigator.NavigatorAction;
import de.renew.navigator.NavigatorGui;
import de.renew.navigator.models.TreeElement;
import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.VersionControlAggregator;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

final class VCColorAction
extends NavigatorAction {
    public static final Logger LOGGER = Logger.getLogger(VCColorAction.class);
    public static final String ICON = "NavigatorVC/src/main/resources/images/diff.gif";
    private final Set<Repository> _repositories;
    private final VersionControlAggregator _holder;
    private final NavigatorGui _gui;

    VCColorAction(Set<Repository> repositories, VersionControlAggregator aggregator, NavigatorGui gui) {
        super("Color changed files.", ICON, null);
        this._repositories = repositories;
        this._holder = aggregator;
        this._gui = gui;
    }

    public void actionPerformed(ActionEvent e) {
        List selectedElements = this._gui.getSelectedElements();
        if (selectedElements.isEmpty()) {
            return;
        }
        TreeElement treeElement = (TreeElement)selectedElements.get(0);
        Repository newRepository = this._holder.findRepository(treeElement.getFile());
        if (newRepository != null) {
            this._repositories.add(newRepository);
            this._gui.getTree().repaint();
        }
    }
}

