/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc;

import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.VersionControl;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class AbstractVersionControl
implements VersionControl {
    public static final Logger LOGGER = Logger.getLogger(AbstractVersionControl.class);
    private static final HashMap<File, Repository> REPOSITORIES = new HashMap();
    private static final String BELONGS_NOT_TO = " belongs not to ";

    @Override
    public final boolean controls(File fileInRepository) {
        return REPOSITORIES.containsKey(fileInRepository) || this.findRepository(fileInRepository) != null;
    }

    @Override
    public final Repository findRepository(File fileInRepository) {
        if (REPOSITORIES.containsKey(fileInRepository)) {
            return REPOSITORIES.get(fileInRepository);
        }
        File rootDirectory = this.findRootDirectory(fileInRepository);
        if (rootDirectory == null) {
            LOGGER.warn((Object)(String.valueOf(fileInRepository) + BELONGS_NOT_TO + this.getName()));
            return null;
        }
        if (REPOSITORIES.containsKey(rootDirectory)) {
            Repository repository = REPOSITORIES.get(rootDirectory);
            REPOSITORIES.put(fileInRepository, repository);
            return repository;
        }
        Repository repository = this.buildRepository(fileInRepository);
        if (repository == null) {
            LOGGER.warn((Object)(String.valueOf(fileInRepository) + BELONGS_NOT_TO + this.getName()));
            return null;
        }
        REPOSITORIES.put(fileInRepository, repository);
        REPOSITORIES.put(repository.getRootDirectory(), repository);
        LOGGER.debug((Object)("Found " + String.valueOf(fileInRepository) + ", belongs to " + this.getName()));
        return repository;
    }

    @Override
    public String getName() {
        String simpleName = this.getClass().getSimpleName();
        int index = simpleName.indexOf("VersionControl");
        return index == -1 ? simpleName : simpleName.substring(0, index);
    }

    protected abstract File findRootDirectory(File var1);

    protected abstract Repository buildRepository(File var1);

    protected void errorException(Exception exception, String action) {
        LOGGER.error((Object)("Error while " + action), (Throwable)exception);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this.getClass().getSimpleName() + ": " + String.valueOf(exception)));
        }
    }
}

