/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.shadow.SyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ChannelCheckNode {
    public final String _name;
    public final int _arity;
    private final int _hash;
    private int _checkState;
    private boolean _satisfiable;
    private Set<ChannelCheckNode> _invokableChannels;

    public ChannelCheckNode(String name, int arity) {
        this._name = name.intern();
        this._arity = arity;
        this._hash = name.hashCode() + arity * 135;
        this._checkState = 0;
        this._satisfiable = false;
        this._invokableChannels = new HashSet<ChannelCheckNode>();
    }

    public void setSatisfiable() {
        this._satisfiable = true;
    }

    public void check() throws SyntaxException {
        String result = this.checkRecursively();
        if (result != null) {
            throw new SyntaxException(result);
        }
    }

    public String makeChannelName() {
        StringBuffer result = new StringBuffer(this._name);
        result.append('(');
        for (int i = 1; i < this._arity; ++i) {
            result.append("*,");
        }
        if (this._arity > 0) {
            result.append('*');
        }
        result.append(')');
        return result.toString();
    }

    public String checkRecursively() throws SyntaxException {
        if (this._checkState == 2) {
            return null;
        }
        if (this._checkState == 1) {
            this._checkState = 3;
            return "This completes a cycle.";
        }
        this._checkState = 1;
        Iterator<ChannelCheckNode> iterator = this._invokableChannels.iterator();
        if (iterator.hasNext()) {
            do {
                ChannelCheckNode node;
                if (this.equals(node = iterator.next())) {
                    throw new SyntaxException("Channel " + this.makeChannelName() + " can invoke itself.");
                }
                Object result = node.checkRecursively();
                if (result == null) continue;
                result = this._name.equals("") ? "Channel " + node.makeChannelName() + " can be invoked spontaneously.\n" + (String)result : "Channel " + this.makeChannelName() + " can invoke channel " + node.makeChannelName() + ".\n" + (String)result;
                if (this._checkState == 3) {
                    throw new SyntaxException((String)result);
                }
                return result;
            } while (iterator.hasNext());
        } else if (!this._satisfiable) {
            throw new SyntaxException("Channel " + this.makeChannelName() + " cannot be satisfied.");
        }
        this._checkState = 2;
        return null;
    }

    public void addInvokableChannel(ChannelCheckNode node) {
        this._invokableChannels.add(node);
    }

    public int hashCode() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChannelCheckNode)) {
            return false;
        }
        ChannelCheckNode that = (ChannelCheckNode)o;
        return this._name.equals(that._name) && this._arity == that._arity;
    }
}

